/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.enchantment;

import crazypants.enderio.base.config.config.EnchantmentConfig;
import crazypants.enderio.base.enchantment.EnchantmentBase;
import crazypants.enderio.base.teleport.RandomTeleportUtil;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public final class EnchantmentRepellent
extends EnchantmentBase {
    @Nonnull
    private static final String NAME = "repellent";

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().register((IForgeRegistryEntry)new EnchantmentRepellent());
    }

    private EnchantmentRepellent() {
        super(NAME, EnchantmentConfig.repellentRarity, EnumEnchantmentType.ARMOR, new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET}, EnchantmentConfig.repellentEnabled);
    }

    public int func_77321_a(int enchantmentLevel) {
        return (Integer)EnchantmentConfig.repellentMinEnchantabilityBase.get() + (Integer)EnchantmentConfig.repellentMinEnchantabilityPerLevel.get() * enchantmentLevel;
    }

    public int func_77317_b(int enchantmentLevel) {
        return (Integer)EnchantmentConfig.repellentMaxEnchantabilityBase.get() + (Integer)EnchantmentConfig.repellentMaxEnchantabilityPerLevel.get() * enchantmentLevel;
    }

    public int func_77325_b() {
        return (Integer)EnchantmentConfig.repellentMaxLevel.get();
    }

    public void func_151367_b(@Nonnull EntityLivingBase user, @Nonnull Entity attacker, int level) {
        if (user instanceof EntityPlayer && attacker instanceof EntityLivingBase && !EnchantmentHelper.func_92099_a((Enchantment)this, (EntityLivingBase)user).func_190926_b()) {
            if (level > this.func_77325_b()) {
                for (Entity e : user.field_70170_p.func_72839_b((Entity)user, user.func_174813_aQ().func_72321_a((double)(level * 8), (double)(level * 4), (double)(level * 8)))) {
                    RandomTeleportUtil.teleportEntity(e.field_70170_p, e, false, false, this.getRange(level));
                }
            } else if (user.func_70681_au().nextFloat() < this.getChance(level)) {
                RandomTeleportUtil.teleportEntity(attacker.field_70170_p, attacker, false, attacker instanceof EntityPlayer || user.func_70681_au().nextFloat() < ((Float)EnchantmentConfig.repellentSafeMobsChance.get()).floatValue(), this.getRange(level));
            }
        }
    }

    private float getChance(int level) {
        return ((Float)EnchantmentConfig.repellentChanceBase.get()).floatValue() + ((Float)EnchantmentConfig.repellentChancePerLevel.get()).floatValue() * (float)level;
    }

    private float getRange(int level) {
        return ((Float)EnchantmentConfig.repellentRangeBase.get()).floatValue() + ((Float)EnchantmentConfig.repellentRangePerLevel.get()).floatValue() * (float)level;
    }
}

