/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Output;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class AbstractCrafting
extends AbstractConditional {
    protected final NNList<Output> outputs = new NNList();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        super.readResolve();
        if (this.outputs.isEmpty()) {
            throw new InvalidRecipeConfigException("Missing <output>");
        }
        List<Output> activeOutputs = this.getOutputs();
        this.valid = this.checkOutputCount(activeOutputs.size());
        for (Output output : activeOutputs) {
            this.valid = this.valid && output.isValid();
        }
        return this;
    }

    protected boolean checkOutputCount(int count) {
        return count == 1;
    }

    public Output getOutput() {
        for (Output output : this.outputs) {
            if (!output.isActive()) continue;
            return output;
        }
        throw new RuntimeException("Missing <output>");
    }

    public List<Output> getOutputs() {
        ArrayList<Output> result = new ArrayList<Output>();
        for (Output output : this.outputs) {
            if (!output.isActive()) continue;
            result.add(output);
        }
        return result;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("output".equals(name)) {
            this.outputs.add((Object)factory.read(new Output(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (Output output : this.outputs) {
            if (!output.isActive()) continue;
            output.enforceValidity();
        }
    }
}

