/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit;

import crazypants.enderio.base.conduit.geom.CollidableComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class RaytraceResult {
    @Nullable
    public final CollidableComponent component;
    @Nonnull
    public final RayTraceResult movingObjectPosition;

    @Nullable
    public static RaytraceResult getClosestHit(@Nonnull Vec3d origin, @Nonnull Collection<RaytraceResult> candidates) {
        double minLengthSquared = Double.POSITIVE_INFINITY;
        RaytraceResult closest = null;
        for (RaytraceResult candidate : candidates) {
            RayTraceResult hit = candidate.movingObjectPosition;
            double lengthSquared = hit.field_72307_f.func_72436_e(origin);
            if (!(lengthSquared < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            closest = candidate;
        }
        return closest;
    }

    public static void sort(final @Nonnull Vec3d origin, @Nonnull List<RaytraceResult> toSort) {
        Collections.sort(toSort, new Comparator<RaytraceResult>(){

            @Override
            public int compare(RaytraceResult o1, RaytraceResult o2) {
                return Double.compare(o1.getDistanceTo(origin), o2.getDistanceTo(origin));
            }
        });
    }

    public RaytraceResult(@Nullable CollidableComponent component, @Nonnull RayTraceResult movingObjectPosition) {
        this.component = component;
        this.movingObjectPosition = movingObjectPosition;
    }

    public double getDistanceTo(@Nonnull Vec3d origin) {
        return this.movingObjectPosition.field_72307_f.func_72436_e(origin);
    }
}

