/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.math;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class MathUtils {
    public static final Random RAND = new Random();
    public static final float[] NORMALS_X = new float[]{0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f};
    public static final float[] NORMALS_Y = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] NORMALS_Z = new float[]{0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f};
    public static final int[] ROTATION_X = new int[]{90, 270, 0, 0, 0, 0};
    public static final int[] ROTATION_Y = new int[]{0, 0, 180, 0, 90, 270};
    private static final AxisAlignedBB[] FULL_BLOCK_AABB_ROTATED_BOXES = new AxisAlignedBB[]{Block.field_185505_j, Block.field_185505_j, Block.field_185505_j, Block.field_185505_j, Block.field_185505_j, Block.field_185505_j};
    private static final int CACHED_SPIRAL_POINTS_SIZE = 81;
    private static ChunkPos[] CACHED_SPIRAL_POINTS = null;

    public static boolean isNumberBetween(int num, int num1, int num2) {
        int min = Math.min(num1, num2);
        int max = Math.max(num1, num2);
        return num >= min && num <= max;
    }

    public static BlockLog.EnumAxis getAxis(BlockPos pos1, BlockPos pos2) {
        int x = pos1.func_177958_n() - pos2.func_177958_n();
        int y = pos1.func_177956_o() - pos2.func_177956_o();
        int z = pos1.func_177952_p() - pos2.func_177952_p();
        if (x != 0 && y == 0 && z == 0) {
            return BlockLog.EnumAxis.X;
        }
        if (x == 0 && y != 0 && z == 0) {
            return BlockLog.EnumAxis.Y;
        }
        if (x == 0 && y == 0 && z != 0) {
            return BlockLog.EnumAxis.Z;
        }
        return BlockLog.EnumAxis.NONE;
    }

    public static boolean isPosBetween(BlockPos pos, BlockPos pos1, BlockPos pos2) {
        int posx = pos.func_177958_n();
        int posy = pos.func_177956_o();
        int posz = pos.func_177952_p();
        int pos1x = pos1.func_177958_n();
        int pos1y = pos1.func_177956_o();
        int pos1z = pos1.func_177952_p();
        if (posx == pos1x && posy == pos1y && posz == pos1z) {
            return true;
        }
        int pos2x = pos2.func_177958_n();
        int pos2y = pos2.func_177956_o();
        int pos2z = pos2.func_177952_p();
        if (posx == pos2x && posy == pos2y && posz == pos2z) {
            return true;
        }
        int x = pos1x - pos2x;
        int y = pos1y - pos2y;
        int z = pos1z - pos2z;
        if (x != 0 && y == 0 && z == 0) {
            return posy == pos1y && posz == pos1z && MathUtils.isNumberBetween(posx, pos1x, pos2x);
        }
        if (x == 0 && y != 0 && z == 0) {
            return posx == pos1x && posz == pos1z && MathUtils.isNumberBetween(posy, pos1y, pos2y);
        }
        if (x == 0 && y == 0 && z != 0) {
            return posx == pos1x && posy == pos1y && MathUtils.isNumberBetween(posz, pos1z, pos2z);
        }
        return false;
    }

    @Nullable
    public static EnumFacing getFacing(BlockPos pos1, BlockPos pos2) {
        int x = pos2.func_177958_n() - pos1.func_177958_n();
        int y = pos2.func_177956_o() - pos1.func_177956_o();
        int z = pos2.func_177952_p() - pos1.func_177952_p();
        if (x != 0 && y == 0 && z == 0) {
            return x > 0 ? EnumFacing.EAST : EnumFacing.WEST;
        }
        if (x == 0 && y != 0 && z == 0) {
            return y > 0 ? EnumFacing.UP : EnumFacing.DOWN;
        }
        if (x == 0 && y == 0 && z != 0) {
            return z > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        return null;
    }

    public static double sq(double value) {
        return value * value;
    }

    public static double sqrt(double value) {
        return value == 0.0 || value == 1.0 ? value : Math.sqrt(value);
    }

    public static double sqrt2sq(double x, double y) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y));
    }

    public static double sqrt3sq(double x, double y, double z) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y) + MathUtils.sq(z));
    }

    public static double distSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 == x2 && y1 == y2 && z1 == z2 ? 0.0 : MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1) + MathUtils.sq(z2 - z1);
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distSq(double x1, double y1, double x2, double y2) {
        return MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1);
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, x2, y2));
    }

    public static int chunk(int i) {
        return i >> 4;
    }

    public static int chunk(double d) {
        return MathUtils.chunk(MathHelper.func_76128_c((double)d));
    }

    public static boolean canParseInt(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean canParseDouble(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static float lerp(float min, float max, float value) {
        return min + (max - min) * value;
    }

    public static double lerp(double min, double max, double value) {
        return min + (max - min) * value;
    }

    public static Vec3d lerp(double x1, double y1, double z1, double x2, double y2, double z2, double value) {
        return new Vec3d(MathUtils.lerp(x1, x2, value), MathUtils.lerp(y1, y2, value), MathUtils.lerp(z1, z2, value));
    }

    public static Vec3d lerp(Vec3d v1, Vec3d v2, double value) {
        return MathUtils.lerp(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, value);
    }

    public static double map(double min1, double max1, double min2, double max2, double value) {
        return MathUtils.lerp(min2, max2, (value - min1) / (max1 - min1));
    }

    public static double mod(double i, double n) {
        return (i %= n) < 0.0 ? i + n : i;
    }

    public static int mod(int i, int n) {
        return (i %= n) < 0 ? i + n : i;
    }

    @Nullable
    public static RayTraceResult rayTrace(Entity entity, double dist, boolean useLiquids) {
        Vec3d start = entity.func_174824_e(1.0f);
        Vec3d look = entity.func_70040_Z();
        Vec3d end = start.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        return entity.field_70170_p.func_147447_a(start, end, useLiquids, !useLiquids, false);
    }

    @Nullable
    public static RayTraceResult rayTrace(EntityPlayer player, boolean useLiquids) {
        return MathUtils.rayTrace((Entity)player, player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e(), useLiquids);
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, Iterable<AxisAlignedBB> boxes) {
        RayTraceResult result = null;
        double dist = Double.POSITIVE_INFINITY;
        int i = 0;
        for (AxisAlignedBB aabb : boxes) {
            double d1;
            RayTraceResult r = MathUtils.collisionRayTrace(pos, start, end, aabb, i, null);
            if (r != null && (d1 = r.field_72307_f.func_72436_e(start)) < dist) {
                result = r;
                dist = d1;
            }
            ++i;
        }
        return result;
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, @Nullable AxisAlignedBB box, int subHit, @Nullable Object hitInfo) {
        if (box == null) {
            return null;
        }
        RayTraceResult result = box.func_186670_a(pos).func_72327_a(start, end);
        if (result == null) {
            return null;
        }
        result = new RayTraceResult(RayTraceResult.Type.BLOCK, result.field_72307_f, result.field_178784_b, pos);
        result.subHit = subHit;
        result.hitInfo = hitInfo;
        return result;
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB box) {
        return MathUtils.collisionRayTrace(pos, start, end, box, -1, null);
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB box, EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return box;
            }
            case UP: {
                return new AxisAlignedBB(1.0 - box.field_72340_a, 1.0 - box.field_72338_b, 1.0 - box.field_72339_c, 1.0 - box.field_72336_d, 1.0 - box.field_72337_e, 1.0 - box.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(box.field_72340_a, box.field_72339_c, box.field_72338_b, box.field_72336_d, box.field_72334_f, box.field_72337_e);
            }
            case SOUTH: {
                box = MathUtils.rotateAABB(box, EnumFacing.NORTH);
                return new AxisAlignedBB(1.0 - box.field_72340_a, box.field_72338_b, 1.0 - box.field_72339_c, 1.0 - box.field_72336_d, box.field_72337_e, 1.0 - box.field_72334_f);
            }
            case WEST: {
                return MathUtils.rotateCW(MathUtils.rotateAABB(box, EnumFacing.SOUTH));
            }
            case EAST: {
                return MathUtils.rotateCW(MathUtils.rotateAABB(box, EnumFacing.NORTH));
            }
        }
        return box;
    }

    public static AxisAlignedBB rotateCW(AxisAlignedBB box) {
        return new AxisAlignedBB(1.0 - box.field_72339_c, box.field_72338_b, box.field_72340_a, 1.0 - box.field_72334_f, box.field_72337_e, box.field_72336_d);
    }

    public static AxisAlignedBB[] getRotatedBoxes(AxisAlignedBB box) {
        if (box.equals((Object)Block.field_185505_j)) {
            return FULL_BLOCK_AABB_ROTATED_BOXES;
        }
        AxisAlignedBB[] boxes = new AxisAlignedBB[6];
        for (EnumFacing f : EnumFacing.field_82609_l) {
            boxes[f.ordinal()] = MathUtils.rotateAABB(box, f);
        }
        return boxes;
    }

    public static boolean intersects(int ax1, int ay1, int ax2, int ay2, int bx1, int by1, int bx2, int by2) {
        return ax1 < bx2 && ax2 > bx1 && ay1 < by2 && ay2 > by1;
    }

    public static boolean intersects(double ax1, double ay1, double ax2, double ay2, double bx1, double by1, double bx2, double by2) {
        return ax1 < bx2 && ax2 > bx1 && ay1 < by2 && ay2 > by1;
    }

    public static ChunkPos getSpiralPoint(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index < 81) {
            if (CACHED_SPIRAL_POINTS == null) {
                CACHED_SPIRAL_POINTS = new ChunkPos[81];
                for (int i = 0; i < 81; ++i) {
                    MathUtils.CACHED_SPIRAL_POINTS[i] = MathUtils.getSpiralPoint0(i);
                }
            }
            return CACHED_SPIRAL_POINTS[index];
        }
        return MathUtils.getSpiralPoint0(index);
    }

    public static ChunkPos getSpiralPoint0(int index) {
        int x = 0;
        int z = 0;
        int p = 1;
        int ringIndex = 0;
        double sqrtceil = Math.ceil(Math.sqrt(index));
        int s = (int)(sqrtceil + (sqrtceil % 2.0 + 1.0) % 2.0);
        if (s > 1) {
            ringIndex = index - (s - 2) * (s - 2);
            p = s * s - (s - 2) * (s - 2);
        }
        int ri = (ringIndex + s / 2) % p;
        if (s > 1) {
            int n = ri < p / 4 ? ri : (ri <= p / 4 * 2 - 1 ? p / 4 : (x = ri <= p / 4 * 3 ? p / 4 * 3 - ri : 0));
        }
        if (s > 1) {
            z = ri < p / 4 ? 0 : (ri <= p / 4 * 2 - 1 ? ri - p / 4 : (ri <= p / 4 * 3 ? p / 4 : p - ri));
        }
        return new ChunkPos(x - s / 2, z - s / 2);
    }
}

