/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.client.IPixelBuffer;
import com.feed_the_beast.ftblib.lib.client.PixelBuffer;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.google.common.base.Objects;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ImageIcon
extends Icon {
    public static final ResourceLocation MISSING_IMAGE = new ResourceLocation("ftblib", "textures/gui/missing_image.png");
    public final ResourceLocation texture;
    public double minU;
    public double minV;
    public double maxU;
    public double maxV;
    public double tileSize;
    public Color4I color;

    public ImageIcon(ResourceLocation tex) {
        this.texture = tex;
        this.minU = 0.0;
        this.minV = 0.0;
        this.maxU = 1.0;
        this.maxV = 1.0;
        this.tileSize = 0.0;
        this.color = Color4I.WHITE;
    }

    @Override
    public ImageIcon copy() {
        ImageIcon icon = new ImageIcon(this.texture);
        icon.minU = this.minU;
        icon.minV = this.minV;
        icon.maxU = this.maxU;
        icon.maxV = this.maxV;
        icon.tileSize = this.tileSize;
        return icon;
    }

    @Override
    protected void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        if (properties.containsKey("u0")) {
            this.minU = Double.parseDouble(properties.get("u0"));
        }
        if (properties.containsKey("v0")) {
            this.minV = Double.parseDouble(properties.get("v0"));
        }
        if (properties.containsKey("u1")) {
            this.maxU = Double.parseDouble(properties.get("u1"));
        }
        if (properties.containsKey("v1")) {
            this.maxV = Double.parseDouble(properties.get("v1"));
        }
        if (properties.containsKey("tile_size")) {
            this.tileSize = Double.parseDouble(properties.get("tile_size"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject tex = manager.func_110581_b(this.texture);
        if (tex == null) {
            tex = new SimpleTexture(this.texture);
            manager.func_110579_a(this.texture, tex);
        }
        GlStateManager.func_179144_i((int)tex.func_110552_b());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h) {
        this.bindTexture();
        if (this.tileSize <= 0.0) {
            GuiHelper.drawTexturedRect(x, y, w, h, this.color, this.minU, this.minV, this.maxU, this.maxV);
        } else {
            int r = this.color.redi();
            int g = this.color.greeni();
            int b = this.color.bluei();
            int a = this.color.alphai();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a((double)x / this.tileSize, (double)(y + h) / this.tileSize).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a((double)(x + w) / this.tileSize, (double)(y + h) / this.tileSize).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a((double)(x + w) / this.tileSize, (double)y / this.tileSize).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)x / this.tileSize, (double)y / this.tileSize).func_181669_b(r, g, b, a).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.texture, this.minU, this.minV, this.maxU, this.maxV});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageIcon) {
            ImageIcon img = (ImageIcon)o;
            return this.texture.equals((Object)img.texture) && this.minU == img.minU && this.minV == img.minV && this.maxU == img.maxU && this.maxV == img.maxV;
        }
        return false;
    }

    public String toString() {
        return this.texture.toString();
    }

    @Override
    public ImageIcon withColor(Color4I color) {
        ImageIcon icon = this.copy();
        icon.color = color;
        return icon;
    }

    @Override
    public ImageIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }

    public ImageIcon withUV(double u0, double v0, double u1, double v1) {
        ImageIcon icon = this.copy();
        icon.minU = u0;
        icon.minV = v0;
        icon.maxU = u1;
        icon.maxV = v1;
        return icon;
    }

    public ImageIcon withUVfromCoords(int x, int y, int w, int h, int tw, int th) {
        return this.withUV((double)x / (double)tw, (double)y / (double)th, (double)(x + w) / (double)tw, (double)(y + h) / (double)th);
    }

    @Override
    public boolean hasPixelBuffer() {
        return true;
    }

    @Override
    @Nullable
    public IPixelBuffer createPixelBuffer() {
        try {
            return PixelBuffer.from(Minecraft.func_71410_x().func_110442_L().func_110536_a(this.texture).func_110527_b());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

