/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import java.util.List;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class ConfigTimer
extends ConfigValue
implements LongSupplier {
    public static final String ID = "timer";
    private Ticks value;
    private Ticks maxValue = Ticks.NO_TICKS;

    public ConfigTimer(Ticks v) {
        this.value = v;
    }

    public ConfigTimer(Ticks v, Ticks max) {
        this(v);
        this.maxValue = max;
    }

    @Override
    public String getId() {
        return ID;
    }

    public ConfigTimer setMax(Ticks v) {
        this.maxValue = v;
        return this;
    }

    public Ticks getMax() {
        return this.maxValue;
    }

    @Override
    public Ticks getTimer() {
        return this.value;
    }

    public void setTimer(Ticks v) {
        Ticks max = this.getMax();
        this.value = max.hasTicks() && v.ticks() >= max.ticks() ? max : v;
    }

    @Override
    public String getString() {
        return this.getTimer().toString();
    }

    @Override
    public boolean getBoolean() {
        return this.getTimer().hasTicks();
    }

    @Override
    public int getInt() {
        return (int)this.getTimer().ticks();
    }

    @Override
    public long getLong() {
        return this.getTimer().ticks();
    }

    @Override
    public ConfigTimer copy() {
        return new ConfigTimer(this.getTimer(), this.getMax());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return value instanceof ConfigTimer && this.getTimer().equalsTimer(value.getTimer());
    }

    @Override
    public Color4I getColor() {
        return ConfigInt.COLOR;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        super.addInfo(inst, list);
        Ticks max = this.getMax();
        if (max.hasTicks()) {
            list.add(TextFormatting.AQUA + "Max: " + TextFormatting.RESET + max);
        }
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.isEmpty()) {
            return false;
        }
        try {
            this.value = Ticks.get(string);
            if (!simulate) {
                this.setTimer(this.value);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74778_a(key, this.getTimer().toString());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setTimer(Ticks.NO_TICKS);
        this.setValueFromString(null, nbt.func_74779_i(key), false);
    }

    @Override
    public void writeData(DataOut data) {
        data.writeVarLong(this.getTimer().ticks());
        data.writeVarLong(this.getMax().ticks());
    }

    @Override
    public void readData(DataIn data) {
        this.setTimer(Ticks.get(data.readVarLong()));
        this.setMax(Ticks.get(data.readVarLong()));
    }

    @Override
    public long getAsLong() {
        return this.getTimer().ticks();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.setTimer(value.getTimer());
    }
}

