/*
 * Decompiled with CFR 0.152.
 */
package com.jolteffect.thermalsolars.utility;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.EnergyStorage;

public class ForgeEnergyStorage
extends EnergyStorage {
    public int mRFPerTick;

    public ForgeEnergyStorage(int capacity) {
        super(capacity);
    }

    public ForgeEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public ForgeEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public ForgeEnergyStorage(int capacity, int maxReceive, int maxExtract, int RFPerTick) {
        super(capacity, maxReceive, maxExtract);
        this.mRFPerTick = RFPerTick;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void modifyEnergyStored(int energy) {
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public EnergyStorage setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
        return this;
    }

    public EnergyStorage setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public EnergyStorage setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public EnergyStorage setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public EnergyStorage setRF(int RF) {
        this.mRFPerTick = RF;
        return this;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public EnergyStorage readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("Energy");
        this.capacity = nbt.func_74762_e("Capacity");
        this.maxExtract = nbt.func_74762_e("MaxExtract");
        this.maxReceive = nbt.func_74762_e("MaxRecieve");
        this.mRFPerTick = nbt.func_74762_e("RFPerTick");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        nbt.func_74768_a("Energy", this.energy);
        nbt.func_74768_a("Capacity", this.capacity);
        nbt.func_74768_a("MaxExtract", this.maxExtract);
        nbt.func_74768_a("MaxRecieve", this.maxReceive);
        nbt.func_74768_a("RFPerTick", this.mRFPerTick);
        return nbt;
    }
}

