/*
 * Decompiled with CFR 0.152.
 */
package com.jolteffect.thermalsolars.tile;

import cofh.redstoneflux.api.IEnergyProvider;
import com.jolteffect.thermalsolars.init.ThermalSolarsConfig;
import com.jolteffect.thermalsolars.utility.BlockUtils;
import com.jolteffect.thermalsolars.utility.ForgeEnergyStorage;
import com.jolteffect.thermalsolars.utility.ForgeEnergyUtils;
import com.jolteffect.thermalsolars.utility.GeneralUtils;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntitySolarStorage
extends TileEntity
implements IEnergyProvider,
IEnergyStorage,
ITickable {
    public int mCapacity;
    public int mMaxExtract;
    public int mMaxReceieve;
    public int mRFPerTick;
    public int mTier;
    public ForgeEnergyStorage forgeEnergyStorage;

    public TileEntitySolarStorage() {
        this.forgeEnergyStorage = new ForgeEnergyStorage(50000, 16, 16, 16);
    }

    public TileEntitySolarStorage(int pTierIndex) {
        switch (pTierIndex) {
            case 1: {
                this.mCapacity = ThermalSolarsConfig.t1Capacity;
                this.mMaxExtract = ThermalSolarsConfig.t1MaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t1MaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t1Generate;
                break;
            }
            case 2: {
                this.mCapacity = ThermalSolarsConfig.t2Capacity;
                this.mMaxExtract = ThermalSolarsConfig.t2MaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t2MaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t2Generate;
                break;
            }
            case 3: {
                this.mCapacity = ThermalSolarsConfig.t3Capacity;
                this.mMaxExtract = ThermalSolarsConfig.t3MaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t3MaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t3Generate;
                break;
            }
            case 4: {
                this.mCapacity = ThermalSolarsConfig.t4Capacity;
                this.mMaxExtract = ThermalSolarsConfig.t4MaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t4MaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t4Generate;
                break;
            }
            case 5: {
                this.mCapacity = ThermalSolarsConfig.t5Capacity;
                this.mMaxExtract = ThermalSolarsConfig.t5MaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t5MaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t5Generate;
                break;
            }
            case 6: {
                this.mCapacity = ThermalSolarsConfig.t6Capacity;
                this.mMaxExtract = ThermalSolarsConfig.t6MaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t6MaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t6Generate;
                break;
            }
            case 101: {
                this.mCapacity = ThermalSolarsConfig.t1lunarCapacity;
                this.mMaxExtract = ThermalSolarsConfig.t1lunarMaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t1lunarMaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t1lunarGenerate;
                break;
            }
            case 102: {
                this.mCapacity = ThermalSolarsConfig.t2lunarCapacity;
                this.mMaxExtract = ThermalSolarsConfig.t2lunarMaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t2lunarMaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t2lunarGenerate;
                break;
            }
            case 103: {
                this.mCapacity = ThermalSolarsConfig.t3lunarCapacity;
                this.mMaxExtract = ThermalSolarsConfig.t3lunarMaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t3lunarMaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t3lunarGenerate;
                break;
            }
            default: {
                this.mCapacity = ThermalSolarsConfig.t1lunarCapacity;
                this.mMaxExtract = ThermalSolarsConfig.t1lunarMaxExtract;
                this.mMaxReceieve = ThermalSolarsConfig.t1lunarMaxReceive;
                this.mRFPerTick = ThermalSolarsConfig.t1lunarGenerate;
            }
        }
        this.mTier = pTierIndex;
        this.forgeEnergyStorage = new ForgeEnergyStorage(this.mCapacity, this.mMaxExtract, this.mMaxReceieve, this.mRFPerTick);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.forgeEnergyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.forgeEnergyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.forgeEnergyStorage.extractEnergy(maxExtract, simulate);
    }

    protected void sendEnergyToNeighbours() {
        for (EnumFacing facing : EnumFacing.values()) {
            if (this.forgeEnergyStorage.getEnergyStored() <= 0) break;
            int sentRF = ForgeEnergyUtils.sendEnergy(this.func_145831_w(), this.func_174877_v(), facing, this.forgeEnergyStorage.extractEnergy(this.forgeEnergyStorage.getMaxExtract(), true));
            this.forgeEnergyStorage.extractEnergy(sentRF, false);
        }
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public void func_73660_a() {
        if (GeneralUtils.isServerSide(this.func_145831_w())) {
            if (this.isRunning()) {
                this.forgeEnergyStorage.receiveEnergy(this.forgeEnergyStorage.mRFPerTick, false);
            }
            this.sendEnergyToNeighbours();
            this.markDirtyClient();
        }
    }

    public boolean isRunning() {
        if (this.mTier <= 100) {
            return BlockUtils.canBlockSeeSky(this.field_174879_c, this.func_145831_w()) && this.func_145831_w().func_72935_r();
        }
        return BlockUtils.canBlockSeeSky(this.field_174879_c, this.func_145831_w()) && !this.func_145831_w().func_72935_r();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.forgeEnergyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.forgeEnergyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.forgeEnergyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.forgeEnergyStorage.getMaxEnergyStored();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.forgeEnergyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Tier", this.mTier);
        this.forgeEnergyStorage.writeToNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mTier = nbt.func_74762_e("Tier");
        this.forgeEnergyStorage.readFromNBT(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }
}

