/*
 * Decompiled with CFR 0.152.
 */
package com.jolteffect.thermalsolars.tile;

import cofh.redstoneflux.api.IEnergyProvider;
import com.jolteffect.thermalsolars.init.ModItems;
import com.jolteffect.thermalsolars.utility.BlockUtils;
import com.jolteffect.thermalsolars.utility.ForgeEnergyStorage;
import com.jolteffect.thermalsolars.utility.ForgeEnergyUtils;
import com.jolteffect.thermalsolars.utility.GeneralUtils;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityEnderPanel
extends TileEntity
implements IEnergyProvider,
IEnergyStorage,
ITickable {
    public int mCapacity = 100000;
    public int mMaxExtract = 100;
    public int mRFPerTick = 100;
    public int capUpgrades;
    public int transferUpgrades;
    public int generateUpgrades;
    public int lunarUpgrades;
    public ForgeEnergyStorage forgeEnergyStorage;
    public static final int SIZE = 4;
    private ItemStackHandler itemStackHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            TileEntityEnderPanel.this.func_70296_d();
        }
    };

    public TileEntityEnderPanel() {
        this.forgeEnergyStorage = new ForgeEnergyStorage(100000, 100, 100, 100);
        this.forgeEnergyStorage.setMaxReceive(10000000);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.forgeEnergyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.forgeEnergyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.forgeEnergyStorage.extractEnergy(maxExtract, simulate);
    }

    protected void sendEnergyToNeighbours() {
        for (EnumFacing facing : EnumFacing.values()) {
            if (this.forgeEnergyStorage.getEnergyStored() <= 0) break;
            int sentRF = ForgeEnergyUtils.sendEnergy(this.func_145831_w(), this.func_174877_v(), facing, this.forgeEnergyStorage.extractEnergy(this.forgeEnergyStorage.getMaxExtract(), true));
            this.forgeEnergyStorage.extractEnergy(sentRF, false);
        }
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public void func_73660_a() {
        if (GeneralUtils.isServerSide(this.func_145831_w())) {
            this.capUpgrades = 0;
            this.transferUpgrades = 0;
            this.generateUpgrades = 0;
            this.lunarUpgrades = 0;
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack == null) continue;
                if (stack.func_77973_b() == ModItems.itemCapUpgrade) {
                    this.capUpgrades += stack.func_77976_d();
                }
                if (stack.func_77973_b() == ModItems.itemTransferUpgrade) {
                    this.transferUpgrades += stack.func_77976_d();
                }
                if (stack.func_77973_b() == ModItems.itemGenerateUpgrade) {
                    this.generateUpgrades += stack.func_77976_d();
                }
                if (stack.func_77973_b() != ModItems.itemLunarUpgrade) continue;
                this.lunarUpgrades += stack.func_77976_d();
            }
            this.forgeEnergyStorage.setCapacity(this.mCapacity + this.capUpgrades * 100000);
            this.forgeEnergyStorage.setMaxExtract(this.mMaxExtract + this.transferUpgrades * 100);
            this.forgeEnergyStorage.setRF(this.mRFPerTick + this.generateUpgrades * 100);
            if (this.isRunning()) {
                this.forgeEnergyStorage.receiveEnergy(this.forgeEnergyStorage.mRFPerTick, false);
            } else if (!this.isRunning() && this.lunarUpgrades > 0) {
                this.forgeEnergyStorage.receiveEnergy(this.forgeEnergyStorage.mRFPerTick, false);
            }
            this.sendEnergyToNeighbours();
            this.markDirtyClient();
        }
    }

    public boolean isRunning() {
        return BlockUtils.canBlockSeeSky(this.field_174879_c, this.func_145831_w()) && this.func_145831_w().func_72935_r();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.forgeEnergyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.forgeEnergyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.forgeEnergyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.forgeEnergyStorage.getMaxEnergyStored();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        this.forgeEnergyStorage.readFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        this.forgeEnergyStorage.writeToNBT(nbt);
        return nbt;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.forgeEnergyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound t = new NBTTagCompound();
        t = this.func_189515_b(t);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, t);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        super.onDataPacket(net, packet);
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }
}

