/*
 * Decompiled with CFR 0.152.
 */
package com.jolteffect.thermalsolars.items;

import com.google.common.collect.ImmutableList;
import com.jolteffect.thermalsolars.creativetabs.ThermalSolarsTabs;
import com.jolteffect.thermalsolars.init.ModItems;
import com.jolteffect.thermalsolars.items.ItemBaseTool;
import com.jolteffect.thermalsolars.utility.RayTracer;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemEnderHammer
extends ItemBaseTool {
    public ItemEnderHammer(Item.ToolMaterial toolMaterial) {
        super(4.0f, -2.0f, toolMaterial);
        this.func_77655_b("thermalsolars.itemenderhammer");
        this.setRegistryName("thermalsolars", "itemenderhammer");
        this.func_77637_a(ThermalSolarsTabs.tab);
        this.addToolClass("pickaxe");
        this.addToolClass("hammer");
        this.setRepairIngot(ModItems.itemEnderIngot.func_77658_a());
        this.func_77656_e(toolMaterial.func_77997_a() * 2);
        this.effectiveMaterials.add((Object)Material.field_151573_f);
        this.effectiveMaterials.add((Object)Material.field_151574_g);
        this.effectiveMaterials.add((Object)Material.field_151576_e);
        this.effectiveMaterials.add((Object)Material.field_151588_w);
        this.effectiveMaterials.add((Object)Material.field_151598_x);
        this.effectiveMaterials.add((Object)Material.field_151592_s);
        this.effectiveMaterials.add((Object)Material.field_151591_t);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185887_b(world, pos) == 0.0f) {
            return false;
        }
        if (!this.canHarvestBlock(state, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }
        if (player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }
        float refStrength = state.func_185903_a(player, world, pos);
        if (refStrength != 0.0f) {
            RayTraceResult traceResult = RayTracer.retrace(player, false);
            if (traceResult == null || traceResult.field_178784_b == null) {
                return false;
            }
            int count = 0;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int radius = 1;
            switch (traceResult.field_178784_b) {
                case DOWN: 
                case UP: {
                    for (int i = x - radius; i <= x + radius; ++i) {
                        for (int j = z - radius; j <= z + radius; ++j) {
                            BlockPos bPos;
                            IBlockState bState;
                            float strength;
                            if (i == x && j == z || !((strength = (bState = world.func_180495_p(bPos = new BlockPos(i, y, j))).func_185903_a(player, world, bPos)) > 0.0f) || !(refStrength / strength <= 4.0f) || !this.harvestBlock(world, bPos, player)) continue;
                            ++count;
                        }
                    }
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    for (int i = x - radius; i <= x + radius; ++i) {
                        for (int j = y - radius; j <= y + radius; ++j) {
                            BlockPos bPos;
                            IBlockState bState;
                            float strength;
                            if (i == x && j == y || !((strength = (bState = world.func_180495_p(bPos = new BlockPos(i, j, z))).func_185903_a(player, world, bPos)) > 0.0f) || !(refStrength / strength <= 4.0f) || !this.harvestBlock(world, bPos, player)) continue;
                            ++count;
                        }
                    }
                    break;
                }
                case WEST: 
                case EAST: {
                    for (int i = y - radius; i <= y + radius; ++i) {
                        for (int j = z - radius; j <= z + radius; ++j) {
                            BlockPos bPos;
                            IBlockState bState;
                            float strength;
                            if (i == y && j == z || !((strength = (bState = world.func_180495_p(bPos = new BlockPos(x, i, j))).func_185903_a(player, world, bPos)) > 0.0f) || !(refStrength / strength <= 4.0f) || !this.harvestBlock(world, bPos, player)) continue;
                            ++count;
                        }
                    }
                    break;
                }
            }
            if (count > 0 && !player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(count, (EntityLivingBase)player);
            }
        }
        return false;
    }

    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, BlockPos pos, EntityPlayer player) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        RayTraceResult traceResult = RayTracer.retrace(player, false);
        if (traceResult != null && traceResult.field_178784_b != null && this.canHarvestBlock(world.func_180495_p(pos), stack) && !player.func_70093_af()) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int radius = 1;
            switch (traceResult.field_178784_b) {
                case DOWN: 
                case UP: {
                    for (int j = x - radius; j <= x + radius; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos harvestPos;
                            if (j == x && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(j, y, k)), stack)) continue;
                            area.add(harvestPos);
                        }
                    }
                    return ImmutableList.copyOf(area);
                }
                case NORTH: 
                case SOUTH: {
                    for (int j = x - radius; j <= x + radius; ++j) {
                        for (int k = y - radius; k <= y + radius; ++k) {
                            BlockPos harvestPos;
                            if (j == x && k == y || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(j, k, z)), stack)) continue;
                            area.add(harvestPos);
                        }
                    }
                    return ImmutableList.copyOf(area);
                }
                case WEST: 
                case EAST: {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos harvestPos;
                            if (j == y && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, j, k)), stack)) continue;
                            area.add(harvestPos);
                        }
                    }
                    break;
                }
            }
            return ImmutableList.copyOf(area);
        }
        return ImmutableList.copyOf(area);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack torch = new ItemStack(Blocks.field_150478_aa);
        if (player.field_71071_by.func_70431_c(torch)) {
            int torchCurrentSlot = player.field_71071_by.func_184429_b(torch);
            player.func_184611_a(hand, player.field_71071_by.func_70301_a(torchCurrentSlot));
            if (torch.func_179546_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ) != EnumActionResult.FAIL) {
                player.func_184611_a(hand, stack);
                return EnumActionResult.SUCCESS;
            }
            player.func_184611_a(hand, stack);
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }
}

