/*
 * Decompiled with CFR 0.152.
 */
package com.jolteffect.thermalsolars.items;

import com.jolteffect.thermalsolars.utility.ItemHelper;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.util.Collections;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemBaseTool
extends ItemTool {
    protected final TLinkedHashSet<String> toolClasses = new TLinkedHashSet();
    protected final Set<String> immutableClasses = Collections.unmodifiableSet(this.toolClasses);
    protected String repairIngot = "";
    protected THashSet<Block> field_150914_c = new THashSet();
    protected THashSet<Material> effectiveMaterials = new THashSet();
    protected int harvestLevel;
    protected boolean showInCreative = true;

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public ItemBaseTool(float baseDamage, float attackSpeed, Item.ToolMaterial toolMaterial) {
        super(baseDamage, attackSpeed, toolMaterial, (Set)null);
        this.harvestLevel = toolMaterial.func_77996_d();
    }

    public ItemBaseTool setRepairIngot(String repairIngot) {
        this.repairIngot = repairIngot;
        return this;
    }

    protected ItemBaseTool addToolClass(String string) {
        this.toolClasses.add((Object)string);
        return this;
    }

    protected boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!this.toolClasses.contains((Object)state.func_177230_c().getHarvestTool(state)) && !this.canHarvestBlock(state, player.func_184614_ca())) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        int xpToDrop = 0;
        if (playerMP != null && (xpToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
            return false;
        }
        if (!world.field_72995_K) {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
                if (!player.field_71075_bZ.field_75098_d) {
                    block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
                    if (xpToDrop > 0) {
                        block.func_180637_b(world, pos, xpToDrop);
                    }
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        return true;
    }

    protected float getEfficiency(ItemStack stack) {
        return this.field_77864_a;
    }

    protected THashSet<Block> getEffectiveBlocks(ItemStack stack) {
        return this.field_150914_c;
    }

    protected THashSet<Material> getEffectiveMaterials(ItemStack stack) {
        return this.effectiveMaterials;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.harvestLevel >= state.func_177230_c().getHarvestLevel(state) && this.func_150893_a(stack, state) > 1.0f;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return ItemHelper.isOreNameEqual(stack, this.repairIngot);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return !this.getEffectiveMaterials(stack).contains((Object)state.func_185904_a()) && !this.getEffectiveBlocks(stack).contains((Object)state) ? 1.0f : this.getEfficiency(stack);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolClasses.isEmpty() ? super.getToolClasses(stack) : this.immutableClasses;
    }
}

