/*
 * Decompiled with CFR 0.152.
 */
package com.jolteffect.thermalsolars.init;

import com.google.common.base.Preconditions;
import com.jolteffect.thermalsolars.block.BlockEnderBlock;
import com.jolteffect.thermalsolars.block.BlockEnderOreEnd;
import com.jolteffect.thermalsolars.block.BlockEnderPanel;
import com.jolteffect.thermalsolars.block.BlockLunarBlock;
import com.jolteffect.thermalsolars.block.BlockLunarOreNether;
import com.jolteffect.thermalsolars.block.BlockSolarPanel;
import com.jolteffect.thermalsolars.block.BlockTitaniumBlock;
import com.jolteffect.thermalsolars.block.BlockTitaniumOre;
import com.jolteffect.thermalsolars.tile.TileEntityEnderPanel;
import com.jolteffect.thermalsolars.tile.TileEntitySolarPanel;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="thermalsolars")
public class ModBlocks {
    public static final BlockSolarPanel blockSolarPanel1 = new BlockSolarPanel("blocksolarpanel1", 1);
    public static final BlockSolarPanel blockSolarPanel2 = new BlockSolarPanel("blocksolarpanel2", 2);
    public static final BlockSolarPanel blockSolarPanel3 = new BlockSolarPanel("blocksolarpanel3", 3);
    public static final BlockSolarPanel blockSolarPanel4 = new BlockSolarPanel("blocksolarpanel4", 4);
    public static final BlockSolarPanel blockSolarPanel5 = new BlockSolarPanel("blocksolarpanel5", 5);
    public static final BlockSolarPanel blockSolarPanel6 = new BlockSolarPanel("blocksolarpanel6", 6);
    public static final BlockSolarPanel blockSolarPanel101 = new BlockSolarPanel("blocksolarpanel101", 101);
    public static final BlockSolarPanel blockSolarPanel102 = new BlockSolarPanel("blocksolarpanel102", 102);
    public static final BlockSolarPanel blockSolarPanel103 = new BlockSolarPanel("blocksolarpanel103", 103);
    public static final BlockTitaniumOre blockTitaniumOre = new BlockTitaniumOre();
    public static final BlockLunarOreNether blockLunarOreNether = new BlockLunarOreNether();
    public static final BlockEnderOreEnd blockEnderOreEnd = new BlockEnderOreEnd();
    public static final BlockEnderPanel blockEnderPanel = new BlockEnderPanel();
    public static final BlockTitaniumBlock blockTitaniumBlock = new BlockTitaniumBlock();
    public static final BlockLunarBlock blockLunarBlock = new BlockLunarBlock();
    public static final BlockEnderBlock blockEnderBlock = new BlockEnderBlock();

    private static void registerTileEntities() {
        ModBlocks.registerTileEntity(TileEntitySolarPanel.class, blockSolarPanel1.func_149739_a());
        ModBlocks.registerTileEntity(TileEntityEnderPanel.class, blockEnderPanel.func_149739_a());
    }

    private static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String name) {
        GameRegistry.registerTileEntity(tileEntityClass, (String)("thermalsolars:" + name));
    }

    private static void registerBlocksDictionary() {
        OreDictionary.registerOre((String)"oreTitanium", (Block)blockTitaniumOre);
        OreDictionary.registerOre((String)"oreLunar", (Block)blockLunarOreNether);
        OreDictionary.registerOre((String)"oreEnder", (Block)blockEnderOreEnd);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels() {
        blockSolarPanel1.initModel();
        blockSolarPanel2.initModel();
        blockSolarPanel3.initModel();
        blockSolarPanel4.initModel();
        blockSolarPanel5.initModel();
        blockSolarPanel6.initModel();
        blockSolarPanel101.initModel();
        blockSolarPanel102.initModel();
        blockSolarPanel103.initModel();
        blockTitaniumOre.initModel();
        blockLunarOreNether.initModel();
        blockEnderOreEnd.initModel();
        blockEnderPanel.initModel();
        blockTitaniumBlock.initModel();
        blockLunarBlock.initModel();
        blockEnderBlock.initModel();
    }

    @Mod.EventBusSubscriber(modid="thermalsolars")
    public static class RegistrationHandler {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            Block[] blocks = new Block[]{blockSolarPanel1, blockSolarPanel2, blockSolarPanel3, blockSolarPanel4, blockSolarPanel5, blockSolarPanel6, blockSolarPanel101, blockSolarPanel102, blockSolarPanel103, blockTitaniumOre, blockLunarOreNether, blockEnderOreEnd, blockEnderPanel, blockTitaniumBlock, blockLunarBlock, blockEnderBlock};
            registry.registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)blockSolarPanel1), new ItemBlock((Block)blockSolarPanel2), new ItemBlock((Block)blockSolarPanel3), new ItemBlock((Block)blockSolarPanel4), new ItemBlock((Block)blockSolarPanel5), new ItemBlock((Block)blockSolarPanel6), new ItemBlock((Block)blockSolarPanel101), new ItemBlock((Block)blockSolarPanel102), new ItemBlock((Block)blockSolarPanel103), new ItemBlock((Block)blockTitaniumOre), new ItemBlock((Block)blockLunarOreNether), new ItemBlock((Block)blockEnderOreEnd), new ItemBlock((Block)blockEnderPanel), new ItemBlock((Block)blockTitaniumBlock), new ItemBlock((Block)blockLunarBlock), new ItemBlock((Block)blockEnderBlock)};
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : items) {
                Block block = item.func_179223_d();
                ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                registry.register(item.setRegistryName(registryName));
                ITEM_BLOCKS.add(item);
            }
            ModBlocks.registerTileEntities();
            ModBlocks.registerBlocksDictionary();
        }
    }
}

