/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.config.sync;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.mattdahepic.mdecore.MDECore;
import com.mattdahepic.mdecore.config.sync.Config;
import com.mattdahepic.mdecore.config.sync.ConfigSyncable;
import com.mattdahepic.mdecore.config.sync.PacketConfigSync;
import com.mattdahepic.mdecore.config.sync.Range;
import com.mattdahepic.mdecore.network.PacketHandler;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;

public class ConfigProcessor {
    private final Class<? extends ConfigSyncable> configClass;
    private final Configuration config;
    final String configFileName;
    public static Map<String, ConfigProcessor> processorMap = Maps.newHashMap();
    private Map<String, Object> defaultValues = Maps.newHashMap();
    public Map<String, Object> currentValues = Maps.newHashMap();
    private Map<String, Object> originalValues = Maps.newHashMap();

    public ConfigProcessor(Class<? extends ConfigSyncable> configClass, Configuration config, String configName) {
        this.configClass = configClass;
        this.config = config;
        this.configFileName = configName;
        MinecraftForge.EVENT_BUS.register((Object)this);
        processorMap.put(configName, this);
    }

    public void process(boolean load) {
        if (load) {
            this.config.load();
        }
        try {
            for (Field f : this.configClass.getDeclaredFields()) {
                if (f.getType().isAssignableFrom(Config.ConfigSubValue.class)) {
                    Config.ConfigSubValue sub = (Config.ConfigSubValue)f.get(null);
                    for (Field iF : sub.getClass().getDeclaredFields()) {
                        this.processField(iF, sub.getConfigName());
                    }
                    continue;
                }
                this.processField(f, "");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.config.save();
    }

    private boolean processField(Field f, String name_prefix) throws Exception {
        Config cfg = f.getAnnotation(Config.class);
        if (cfg == null) {
            return false;
        }
        String name = f.getName();
        String map_name = name_prefix + "\\" + name;
        Object value = this.defaultValues.get(map_name);
        if (value == null) {
            value = f.get(null);
            this.defaultValues.put(map_name, value);
        }
        Class<?> c = f.getType();
        String comment = StringUtils.join((Object[])cfg.comment(), (String)"\n");
        Range<Double> range = Range.of(cfg.range());
        Property prop = null;
        Object newValue = null;
        block6: for (ConfigType type : ConfigType.values()) {
            if (c != type.primitiveType && c != type.actualType.getRawType()) continue;
            switch (type) {
                case BOOLEAN: 
                case BOOLEAN_ARR: 
                case BOOLEAN_LIST: {
                    if (c.isArray()) {
                        prop = this.config.get(cfg.cat(), name, (boolean[])this.defaultValues.get(map_name), comment);
                        newValue = prop.getBooleanList();
                        continue block6;
                    }
                    prop = this.config.get(cfg.cat(), name, ((Boolean)this.defaultValues.get(map_name)).booleanValue(), comment);
                    newValue = prop.getBoolean();
                    continue block6;
                }
                case DOUBLE: 
                case DOUBLE_ARR: 
                case DOUBLE_LIST: {
                    if (c.isArray()) {
                        prop = this.config.get(cfg.cat(), name, (double[])this.defaultValues.get(map_name), comment);
                        newValue = range.clampArr(Arrays.asList(new double[][]{prop.getDoubleList()})).toArray();
                        continue block6;
                    }
                    prop = this.config.get(cfg.cat(), name, ((Double)this.defaultValues.get(map_name)).doubleValue(), comment);
                    newValue = range.clamp(prop.getDouble());
                    continue block6;
                }
                case INTEGER: 
                case INTEGER_ARR: 
                case INTEGER_LIST: {
                    if (c.isArray()) {
                        prop = this.config.get(cfg.cat(), name, (int[])this.defaultValues.get(map_name), comment);
                        newValue = range.clampArr(Arrays.asList(new int[][]{prop.getIntList()})).toArray();
                        continue block6;
                    }
                    prop = this.config.get(cfg.cat(), name, ((Integer)this.defaultValues.get(map_name)).intValue(), comment);
                    newValue = range.clamp((Double)prop.getInt());
                    continue block6;
                }
                case STRING: 
                case STRING_ARR: 
                case STRING_LIST: {
                    if (c.isArray()) {
                        prop = this.config.get(cfg.cat(), name, (String[])this.defaultValues.get(map_name), comment);
                        newValue = prop.getStringList();
                        continue block6;
                    }
                    prop = this.config.get(cfg.cat(), name, (String)this.defaultValues.get(map_name), comment);
                    newValue = prop.getString();
                    continue block6;
                }
                default: {
                    throw new RuntimeException(String.format("Attempted to assign config value to non-number, non-string field %s", f.getName()));
                }
            }
        }
        range.apply(prop);
        if (!range.equals(Range.MAX_RANGE)) {
            if (((Number)range.min).doubleValue() == (double)((Number)range.min).intValue() && ((Number)range.max).intValue() == ((Number)range.max).intValue()) {
                prop.setComment(prop.getComment() + String.format("\nRange: [%s - %s]", ((Number)range.min).intValue(), ((Number)range.max).intValue()));
            } else {
                prop.setComment(prop.getComment() + String.format("\nRange: [%s - %s]", range.min, range.max));
            }
        }
        cfg.restartReq().apply(prop);
        this.currentValues.put(map_name, newValue);
        this.originalValues.put(map_name, newValue);
        f.set(null, newValue);
        return !value.equals(newValue);
    }

    void syncTo(Map<String, Object> values) {
        this.currentValues = values;
        try {
            for (Field f : this.configClass.getDeclaredFields()) {
                if (this.currentValues.containsKey("\\" + f.getName())) {
                    Config annot = f.getAnnotation(Config.class);
                    if (annot == null) continue;
                    if (annot.sync()) {
                        Object newVal = this.currentValues.get("\\" + f.getName());
                        Object oldVal = f.get(null);
                        if (oldVal.equals(newVal)) continue;
                        MDECore.logger.debug("Config {}.{} differs from new data. Changing from {} to {}", (Object)this.configClass.getName(), (Object)f.getName(), oldVal, newVal);
                        f.set(null, newVal);
                        continue;
                    }
                    MDECore.logger.debug("Skipping syncing field {}.{} as it was marked sync=false", (Object)this.configClass.getName(), (Object)f.getName());
                    continue;
                }
                if (!f.getType().isAssignableFrom(Config.ConfigSubValue.class)) continue;
                Config.ConfigSubValue sub = (Config.ConfigSubValue)f.get(null);
                for (Field iF : sub.getClass().getDeclaredFields()) {
                    Config annot = iF.getAnnotation(Config.class);
                    if (annot == null) continue;
                    if (annot.sync()) {
                        Object newVal = this.currentValues.get(sub.getConfigName() + "\\" + iF.getName());
                        Object oldVal = f.get(null);
                        if (oldVal.equals(newVal)) continue;
                        MDECore.logger.debug("Config {}.{}.{} differs from new data. Changing from {} to {}", (Object)this.configClass.getName(), (Object)sub.getConfigName(), (Object)iF.getName(), oldVal, newVal);
                        f.set(null, newVal);
                        continue;
                    }
                    MDECore.logger.debug("Skipping syncing field {}.{}.{} as it was marked sync=false", (Object)this.configClass.getName(), (Object)sub.getConfigName(), (Object)iF.getName());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MDECore.logger.debug(String.format("Sending server configs to client %s for %s", event.player.getDisplayNameString(), this.configFileName + ".cfg"));
        PacketHandler.net.sendTo((IMessage)new PacketConfigSync(this), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onPlayerLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.syncTo(this.originalValues);
        MDECore.logger.debug(String.format("Reset configs to client values for %s", this.configFileName + ".cfg"));
    }

    private static enum ConfigType {
        INTEGER(TypeToken.of(Integer.class), Property.Type.INTEGER, Integer.TYPE),
        INTEGER_ARR(TypeToken.of(int[].class), Property.Type.INTEGER),
        DOUBLE(TypeToken.of(Double.class), Property.Type.DOUBLE, Double.TYPE),
        DOUBLE_ARR(TypeToken.of(double[].class), Property.Type.DOUBLE),
        BOOLEAN(TypeToken.of(Boolean.class), Property.Type.BOOLEAN, Boolean.TYPE),
        BOOLEAN_ARR(TypeToken.of(boolean[].class), Property.Type.BOOLEAN),
        STRING(TypeToken.of(String.class), Property.Type.STRING, String.class),
        STRING_ARR(TypeToken.of(String[].class), Property.Type.STRING),
        FLOAT(TypeToken.of(Float.class), Property.Type.DOUBLE, Float.TYPE),
        FLOAT_ARR(TypeToken.of(float[].class), Property.Type.DOUBLE),
        INTEGER_LIST((TypeToken)new TypeToken<List<Integer>>(){}, Property.Type.INTEGER),
        DOUBLE_LIST((TypeToken)new TypeToken<List<Double>>(){}, Property.Type.DOUBLE),
        FLOAT_LIST((TypeToken)new TypeToken<List<Float>>(){}, Property.Type.DOUBLE),
        BOOLEAN_LIST((TypeToken)new TypeToken<List<Boolean>>(){}, Property.Type.BOOLEAN),
        STRING_LIST((TypeToken)new TypeToken<List<String>>(){}, Property.Type.STRING);

        private final TypeToken actualType;
        private final Property.Type type;
        private final Class<?> primitiveType;

        private ConfigType(TypeToken actualType, Property.Type type, Class<?> primitiveType) {
            this.actualType = actualType;
            this.type = type;
            this.primitiveType = primitiveType;
        }

        private ConfigType(TypeToken actualType, Property.Type type) {
            this(actualType, type, null);
        }
    }
}

