/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.util.item.AEItemStack;
import extracells.container.ContainerOreDictExport;
import extracells.gui.GuiOreDictExport;
import extracells.models.PartModels;
import extracells.part.PartECBase;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.util.ItemHandlerUtil;
import extracells.util.ItemUtils;
import extracells.util.MachineSource;
import extracells.util.StorageChannels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class PartOreDictExporter
extends PartECBase
implements IGridTickable {
    private String filter = "";
    private Predicate<ItemStack> filterPredicate = null;
    private ItemStack[] oreDictFilteredItems;

    public float getCableConnectionLength(AECableType aeCableType) {
        return 5.0f;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateFilter();
        this.saveData();
    }

    private void updateFilter() {
        if (!this.filter.trim().isEmpty()) {
            ArrayList matchingNames = new ArrayList();
            Predicate<ItemStack> matcher = null;
            String[] filters = this.filter.split("[&|]");
            String lastFilter = null;
            for (String filter : filters) {
                int startThis;
                boolean negated = (filter = filter.trim()).startsWith("!");
                if (negated) {
                    filter = filter.substring(1);
                }
                Predicate<ItemStack> test = this.filterToItemStackPredicate(filter);
                if (negated) {
                    test = test.negate();
                }
                if (matcher == null) {
                    matcher = test;
                    lastFilter = filter;
                    continue;
                }
                int endLast = this.filter.indexOf(lastFilter) + lastFilter.length();
                boolean or = this.filter.substring(endLast, startThis = this.filter.indexOf(filter)).contains("|");
                matcher = or ? matcher.or(test) : matcher.and(test);
            }
            if (matcher == null) {
                this.filterPredicate = null;
                this.oreDictFilteredItems = new ItemStack[0];
                return;
            }
            if (!this.filter.contains("@") && !this.filter.contains("~")) {
                this.oreDictFilteredItems = (ItemStack[])Arrays.stream(OreDictionary.getOreNames()).flatMap(name -> OreDictionary.getOres((String)name).stream()).filter(matcher).toArray(ItemStack[]::new);
                this.filterPredicate = null;
            } else {
                this.filterPredicate = matcher;
                this.oreDictFilteredItems = new ItemStack[0];
            }
        } else {
            this.filterPredicate = null;
            this.oreDictFilteredItems = new ItemStack[0];
        }
    }

    private Predicate<ItemStack> filterToItemStackPredicate(String filter) {
        if (filter.startsWith("@")) {
            Predicate<String> test = this.filterToPredicate(filter.substring(1));
            return is -> Optional.ofNullable(is.func_77973_b().getRegistryName()).map(ResourceLocation::func_110624_b).map(test::test).orElse(false);
        }
        if (filter.startsWith("~")) {
            Predicate<String> test = this.filterToPredicate(filter.substring(1));
            return is -> Optional.ofNullable(is.func_77973_b().getRegistryName()).map(ResourceLocation::func_110623_a).map(test::test).orElse(false);
        }
        Predicate<String> test = this.filterToPredicate(filter);
        return is -> IntStream.of(OreDictionary.getOreIDs((ItemStack)is)).mapToObj(OreDictionary::getOreName).anyMatch(test);
    }

    private Predicate<String> filterToPredicate(String filter) {
        int numStars = StringUtils.countMatches((CharSequence)filter, (char)'*');
        if (numStars == filter.length()) {
            return str -> true;
        }
        if (filter.length() > 2 && filter.startsWith("*") && filter.endsWith("*") && numStars == 2) {
            String pattern = filter.substring(1, filter.length() - 1);
            return str -> str.contains(pattern);
        }
        if (filter.length() >= 2 && filter.startsWith("*") && numStars == 1) {
            String pattern = filter.substring(1);
            return str -> str.endsWith(pattern);
        }
        if (filter.length() >= 2 && filter.endsWith("*") && numStars == 1) {
            String pattern = filter.substring(0, filter.length() - 1);
            return str -> str.startsWith(pattern);
        }
        if (numStars == 0) {
            return str -> str.equals(filter);
        }
        String filterRegexFragment = filter.replace("*", ".*");
        String regexPattern = "^" + filterRegexFragment + "$";
        Pattern pattern = Pattern.compile(regexPattern);
        return pattern.asPredicate();
    }

    public boolean doWork(int rate, int ticksSinceLastCall) {
        int amount = Math.min(rate * ticksSinceLastCall, 64);
        IStorageGrid storage = this.getStorageGrid();
        assert (storage != null);
        IMEMonitor inv = storage.getInventory((IStorageChannel)StorageChannels.ITEM());
        MachineSource src = new MachineSource(this);
        if (this.filterPredicate != null) {
            IItemList items = inv.getStorageList();
            for (IAEItemStack stack : items) {
                IAEItemStack exported;
                if (!this.filterPredicate.test(stack.createItemStack())) continue;
                IAEItemStack toExtract = stack.copy();
                toExtract.setStackSize((long)amount);
                IAEItemStack extracted = (IAEItemStack)inv.extractItems((IAEStack)toExtract, Actionable.SIMULATE, (IActionSource)src);
                if (extracted == null || (exported = this.exportStack(extracted.copy())) == null) continue;
                inv.extractItems((IAEStack)exported, Actionable.MODULATE, (IActionSource)src);
                return true;
            }
            return false;
        }
        for (ItemStack is : this.oreDictFilteredItems) {
            IAEItemStack exported;
            ItemStack toExtract = is.func_77946_l();
            toExtract.func_190920_e(amount);
            IAEItemStack extracted = (IAEItemStack)inv.extractItems((IAEStack)AEItemStack.fromItemStack((ItemStack)toExtract), Actionable.SIMULATE, (IActionSource)src);
            if (extracted == null || (exported = this.exportStack(extracted.copy())) == null) continue;
            inv.extractItems((IAEStack)exported, Actionable.MODULATE, (IActionSource)src);
            return true;
        }
        return false;
    }

    public IAEItemStack exportStack(IAEItemStack stack0) {
        block12: {
            DimensionalCoord location = this.getLocation();
            if (location == null || stack0 == null) {
                return null;
            }
            EnumFacing facing = this.getFacing();
            BlockPos pos = location.getPos();
            TileEntity tile = location.getWorld().func_175625_s(pos.func_177972_a(facing));
            if (tile == null) {
                return null;
            }
            IAEItemStack stack = stack0.copy();
            if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                ItemStack itemStack;
                IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                ItemStack notExported = ItemHandlerUtil.insertItemStack(itemHandler, itemStack = stack.createItemStack(), false);
                if (notExported.func_190926_b()) {
                    return stack;
                }
                return (IAEItemStack)stack.setStackSize(stack.getStackSize() - (long)notExported.func_190916_E());
            }
            if (!(tile instanceof IInventory)) break block12;
            if (tile instanceof ISidedInventory) {
                ISidedInventory inv = (ISidedInventory)tile;
                for (int i : inv.func_180463_a(facing.func_176734_d())) {
                    if (!inv.func_180462_a(i, stack.createItemStack(), facing.func_176734_d())) continue;
                    ItemStack invStack = inv.func_70301_a(i);
                    if (invStack == null || invStack.func_190926_b()) {
                        inv.func_70299_a(i, stack.createItemStack());
                        return stack0;
                    }
                    if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), stack.createItemStack())) continue;
                    int max = inv.func_70297_j_();
                    int current = inv.func_70301_a(i).func_190916_E();
                    int outStack = (int)stack.getStackSize();
                    if (max == current) continue;
                    if (current + outStack <= max) {
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.func_190920_e(s.func_190916_E() + outStack);
                        inv.func_70299_a(i, s);
                        return stack0;
                    }
                    ItemStack s = inv.func_70301_a(i).func_77946_l();
                    s.func_190920_e(max);
                    inv.func_70299_a(i, s);
                    stack.setStackSize((long)(max - current));
                    return stack;
                }
            } else {
                IInventory inv = (IInventory)tile;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    if (!inv.func_94041_b(i, stack.createItemStack())) continue;
                    ItemStack invStack = inv.func_70301_a(i);
                    if (invStack == null || invStack.func_190926_b()) {
                        inv.func_70299_a(i, stack.createItemStack());
                        return stack0;
                    }
                    if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), stack.createItemStack())) continue;
                    int max = inv.func_70297_j_();
                    int current = inv.func_70301_a(i).func_190916_E();
                    int outStack = (int)stack.getStackSize();
                    if (max == current) continue;
                    if (current + outStack <= max) {
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.func_190920_e(s.func_190916_E() + outStack);
                        inv.func_70299_a(i, s);
                        return stack0;
                    }
                    ItemStack s = inv.func_70301_a(i).func_77946_l();
                    s.func_190920_e(max);
                    inv.func_70299_a(i, s);
                    stack.setStackSize((long)(max - current));
                    return stack;
                }
            }
        }
        return null;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 12.0, 10.0, 10.0, 13.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiOreDictExport(player, this);
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        ItemStack is = new ItemStack(ItemEnum.PARTITEM.getItem(), 1, PartEnum.getPartID(this));
        if (type != PartItemStack.BREAK) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("filter", this.filter);
            is.func_77982_d(tag);
        }
        return is;
    }

    @Override
    public double getPowerUsage() {
        return 10.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerOreDictExport(player, this);
    }

    private IStorageGrid getStorageGrid() {
        IGridNode node = this.getGridNode();
        if (node == null) {
            return null;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return null;
        }
        return (IStorageGrid)grid.getCache(IStorageGrid.class);
    }

    public final TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound data, List<String> list) {
        super.getWailaBodey(data, list);
        if (data.func_74764_b("name")) {
            list.add(I18n.func_74838_a((String)"extracells.tooltip.oredict") + ": " + data.func_74779_i("name"));
        } else {
            list.add(I18n.func_74838_a((String)"extracells.tooltip.oredict") + ":");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        super.getWailaTag(tag);
        tag.func_74778_a("name", this.filter);
        return tag;
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkPowerStatusChange event) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("filter")) {
            this.filter = data.func_74779_i("filter");
            this.updateFilter();
        }
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.EXPORT_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.EXPORT_ON;
        }
        return PartModels.EXPORT_OFF;
    }

    public final TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isActive()) {
            return this.doWork(10, ticksSinceLastCall) ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        return TickRateModulation.SLOWER;
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged channel) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74778_a("filter", this.filter);
    }
}

