/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui.widget;

import extracells.gui.GuiBase;
import extracells.gui.widget.AbstractWidget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WidgetManager {
    public final GuiBase gui;
    public final Minecraft mc;
    protected final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();

    public WidgetManager(GuiBase gui) {
        this.gui = gui;
        this.mc = Minecraft.func_71410_x();
    }

    public void add(AbstractWidget widget) {
        this.widgets.add(widget);
    }

    public void remove(AbstractWidget slot) {
        this.widgets.remove(slot);
    }

    public void clear() {
        this.widgets.clear();
    }

    public List<AbstractWidget> getWidgets() {
        return this.widgets;
    }

    public void drawWidgets(int mouseX, int mouseY) {
        mouseX -= this.gui.getGuiLeft();
        mouseY -= this.gui.getGuiTop();
        boolean overlay = false;
        for (AbstractWidget widget : this.widgets) {
            widget.draw(mouseX, mouseY);
            if (overlay || !widget.isMouseOver(mouseX, mouseY)) continue;
            widget.drawOverlay(mouseX, mouseY);
            overlay = true;
        }
    }

    @Nullable
    public AbstractWidget getAtPosition(int mX, int mY) {
        for (AbstractWidget slot : this.widgets) {
            if (!slot.isMouseOver(mX, mY)) continue;
            return slot;
        }
        return null;
    }

    public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        AbstractWidget slot = this.getAtPosition(mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop());
        if (slot != null) {
            slot.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }
}

