/*
 * Decompiled with CFR 0.152.
 */
package openblocks.integration;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openblocks.common.item.MetasGeneric;
import openblocks.integration.ITickingTurtle;
import openblocks.integration.MagnetControlAdapter;
import openperipheral.api.ApiAccess;
import openperipheral.api.architecture.cc.IComputerCraftObjectsFactory;
import org.apache.commons.lang3.tuple.Pair;

public class MagnetTurtleUpgrade
implements ITurtleUpgrade {
    public ResourceLocation getUpgradeID() {
        return OpenBlocks.location("magnet_turtle");
    }

    public int getLegacyUpgradeID() {
        return 9260;
    }

    public String getUnlocalisedAdjective() {
        return "openblocks.turtle.magnet";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    @Nonnull
    public ItemStack getCraftingItem() {
        return MetasGeneric.miracleMagnet.newItemStack();
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return ((IComputerCraftObjectsFactory)ApiAccess.getApi(IComputerCraftObjectsFactory.class)).createPeripheral((Object)new MagnetControlAdapter(turtle, side));
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, EnumFacing direction) {
        return null;
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
        IPeripheral peripheral = turtle.getPeripheral(side);
        if (peripheral instanceof ITickingTurtle) {
            ((ITickingTurtle)peripheral).onPeripheralTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, TurtleSide side) {
        Minecraft mc = Minecraft.func_71410_x();
        ModelManager modelManager = mc.func_175599_af().func_175037_a().func_178083_a();
        ModelResourceLocation location = new ModelResourceLocation(side == TurtleSide.Left ? "computercraft:turtle_crafting_table_left" : "computercraft:turtle_crafting_table_right", "inventory");
        return Pair.of((Object)modelManager.func_174953_a(location), null);
    }
}

