/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.recipe;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.item.ItemImaginary;
import openblocks.common.item.ItemImaginationGlasses;
import openmods.utils.ItemUtils;

public class CrayonGlassesRecipe
extends ShapelessRecipes {
    private static NonNullList<Ingredient> createFakeIngredientsList() {
        ItemStack block = new ItemStack((Block)OpenBlocks.Blocks.imaginary, 1, 1);
        ItemImaginary.setupValues(block, 65535);
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151121_aF), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{block})});
    }

    @Nonnull
    private static ItemStack createFakeResult() {
        return ItemImaginationGlasses.ItemCrayonGlasses.createCrayonGlasses(OpenBlocks.Items.crayonGlasses, 65535);
    }

    public CrayonGlassesRecipe() {
        super(OpenBlocks.location("crayons").toString(), CrayonGlassesRecipe.createFakeResult(), CrayonGlassesRecipe.createFakeIngredientsList());
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        int crayonCount = 0;
        int paperCount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (ItemImaginary.isCrayon(stack)) {
                ++crayonCount;
                continue;
            }
            if (stack.func_77973_b() == Items.field_151121_aF) {
                ++paperCount;
                continue;
            }
            return false;
        }
        return crayonCount == 1 && paperCount == 1;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !ItemImaginary.isCrayon(stack)) continue;
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            int color = tag.func_74762_e("Color");
            return ItemImaginationGlasses.ItemCrayonGlasses.createCrayonGlasses(OpenBlocks.Items.crayonGlasses, color);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }
}

