/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.collect.MapMaker;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.common.IVarioController;
import openblocks.common.Vario;
import openblocks.common.item.ItemHangGlider;
import openmods.Log;
import openmods.OpenMods;

public class EntityHangGlider
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int THERMAL_HEIGTH_MIN = 70;
    public static final int THERMAL_HEIGTH_OPT = 110;
    public static final int THERMAL_HEIGTH_MAX = 136;
    public static final int THERMAL_STRONG_BONUS_HEIGTH = 100;
    public static final double VSPEED_NORMAL = -0.052;
    public static final double VSPEED_FAST = -0.176;
    public static final double VSPEED_MIN = -0.32;
    public static final double VSPEED_MAX = 0.4;
    private static final int TICKS_PER_VARIO_UPDATE = 4;
    public static final int FREQ_MIN = 300;
    public static final int FREQ_AVG = 600;
    public static final int FREQ_MAX = 2000;
    public static final int BEEP_RATE_AVG = 4;
    public static final int BEEP_RATE_MAX = 24;
    private static final DataParameter<Boolean> PROPERTY_DEPLOYED = EntityDataManager.func_187226_a(EntityHangGlider.class, (DataSerializer)DataSerializers.field_187198_h);
    private static Map<EntityPlayer, EntityHangGlider> gliderMap = new MapMaker().weakKeys().weakValues().makeMap();
    private IVarioController varioControl = IVarioController.NULL;
    private EntityPlayer player;
    private NoiseGeneratorPerlin noiseGen;
    private int ticksSinceLastVarioUpdate = 0;
    private double verticalMotionSinceLastVarioUpdate = 0.0;
    private double lastMotionY = 0.0;
    private EnumHand handHeld = EnumHand.MAIN_HAND;

    public static boolean isHeldStackDeployedGlider(EntityLivingBase player, @Nonnull ItemStack heldStack) {
        if (player == null) {
            return false;
        }
        EntityHangGlider glider = gliderMap.get(player);
        if (glider == null || glider.handHeld == null) {
            return false;
        }
        return player.func_184586_b(glider.handHeld) == heldStack;
    }

    public static boolean isGliderDeployed(Entity player) {
        EntityHangGlider glider = gliderMap.get(player);
        return glider != null && glider.isDeployed();
    }

    private static boolean isItemHangglider(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemHangGlider;
    }

    private static boolean isGliderValid(EntityPlayer player, EntityHangGlider glider) {
        if (player == null || player.field_70128_L || glider == null || glider.field_70128_L) {
            return false;
        }
        if (glider.handHeld == null || !EntityHangGlider.isItemHangglider(player.func_184586_b(glider.handHeld))) {
            return false;
        }
        if (player.field_70170_p.field_73011_w.getDimension() != glider.field_70170_p.field_73011_w.getDimension()) {
            return false;
        }
        return !player.func_184613_cA() && !player.func_175149_v();
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateGliders(World world) {
        for (Map.Entry<EntityPlayer, EntityHangGlider> e : gliderMap.entrySet()) {
            EntityHangGlider glider;
            EntityPlayer player = e.getKey();
            if (EntityHangGlider.isGliderValid(player, glider = e.getValue())) {
                glider.fixPositions(player, player instanceof EntityPlayerSP);
                continue;
            }
            glider.func_70106_y();
        }
    }

    public EntityHangGlider(World world) {
        super(world);
        this.noiseGen = new NoiseGeneratorPerlin(new Random(world.func_83015_S().get(6)), 2);
    }

    public EntityHangGlider(World world, EntityPlayer player, EnumHand spawnedHand) {
        this(world);
        this.player = player;
        this.handHeld = spawnedHand;
    }

    public void readSpawnData(ByteBuf data) {
        int playerId = data.readInt();
        Entity e = this.field_70170_p.func_73045_a(playerId);
        if (e instanceof EntityPlayer) {
            this.player = (EntityPlayer)e;
            gliderMap.put(this.player, this);
            if (OpenMods.proxy.isClientPlayer((Entity)this.player)) {
                this.varioControl = Vario.instance.acquire();
            }
        } else {
            this.func_70106_y();
        }
        PacketBuffer buf = new PacketBuffer(data);
        this.handHeld = (EnumHand)buf.func_179257_a(EnumHand.class);
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.player == null) {
            Log.warn((String)"Got glider without player id (%s)", (Object[])new Object[]{this});
            data.writeInt(-42);
        } else {
            data.writeInt(this.player.func_145782_y());
        }
        PacketBuffer buf = new PacketBuffer(data);
        buf.func_179249_a((Enum)this.handHeld);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PROPERTY_DEPLOYED, (Object)false);
    }

    public boolean isDeployed() {
        return (Boolean)this.field_70180_af.func_187225_a(PROPERTY_DEPLOYED);
    }

    public void func_70071_h_() {
        boolean isDeployed;
        if (!EntityHangGlider.isGliderValid(this.player, this)) {
            this.func_70106_y();
        }
        if (this.field_70128_L) {
            gliderMap.remove(this.player);
            return;
        }
        this.varioControl.keepAlive();
        boolean bl = isDeployed = !this.player.field_70122_E && !this.player.func_70090_H() && !this.player.func_70608_bn();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(PROPERTY_DEPLOYED, (Object)isDeployed);
            this.fixPositions(this.player, false);
        }
        if (isDeployed) {
            if (this.player.field_70181_x < this.lastMotionY) {
                double verticalSpeed;
                double horizontalSpeed;
                double vspeed;
                double noise = Config.hanggliderEnableThermal ? this.getNoise() : 0.0;
                double d = vspeed = noise >= 0.0 ? 0.4 : 0.32;
                if (this.player.func_70093_af()) {
                    horizontalSpeed = 0.1;
                    verticalSpeed = Math.max(-0.176 + noise * vspeed, -0.32);
                } else {
                    horizontalSpeed = 0.03;
                    verticalSpeed = Math.max(-0.052 + noise * vspeed, -0.32);
                }
                this.player.field_70181_x = verticalSpeed;
                this.field_70181_x = verticalSpeed;
                this.lastMotionY = verticalSpeed;
                if (this.varioControl.isValid()) {
                    ++this.ticksSinceLastVarioUpdate;
                    this.verticalMotionSinceLastVarioUpdate += verticalSpeed;
                    if (this.ticksSinceLastVarioUpdate > 4) {
                        this.updateVario(this.verticalMotionSinceLastVarioUpdate / 4.0);
                        this.ticksSinceLastVarioUpdate = 0;
                        this.verticalMotionSinceLastVarioUpdate = 0.0;
                    }
                }
                double x = Math.cos(Math.toRadians(this.player.field_70759_as + 90.0f)) * horizontalSpeed;
                double z = Math.sin(Math.toRadians(this.player.field_70759_as + 90.0f)) * horizontalSpeed;
                this.player.field_70159_w += x;
                this.player.field_70179_y += z;
                this.player.field_70143_R = 0.0f;
            }
        } else if (this.varioControl.isValid()) {
            this.varioControl.setFrequencies(0.0, 0.0);
            this.ticksSinceLastVarioUpdate = 0;
            this.verticalMotionSinceLastVarioUpdate = 0.0;
        }
    }

    private void updateVario(double vspeed) {
        if (vspeed <= 0.0) {
            vspeed = Math.max(-0.32, vspeed);
            double freq = (vspeed - -0.32) / Math.abs(-0.32) * 300.0 + 300.0;
            this.varioControl.setFrequencies(freq, 0.0);
        } else {
            vspeed = Math.min(0.4, vspeed);
            double freq = vspeed / Math.abs(0.4) * 1400.0 + 600.0;
            double beepfreq = vspeed / Math.abs(0.4) * 20.0 + 4.0;
            this.varioControl.setFrequencies(freq, beepfreq);
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public EnumHand getHandHeld() {
        return this.handHeld;
    }

    public double getNoise() {
        double noise = this.noiseGen.func_151601_a(this.player.field_70165_t / 20.0, this.player.field_70161_v / 20.0) / 4.0;
        boolean strong = noise > 0.7;
        int bonus = strong ? 100 : 0;
        BlockPos pos = this.player.func_180425_c();
        float biomeRain = this.field_70170_p.getBiomeForCoordsBody(pos).func_76727_i();
        noise *= Math.min(Math.max(this.player.field_70163_u - 70.0, 0.0) / 40.0, 1.0);
        noise *= Math.min(Math.max((double)(136 + bonus) - this.player.field_70163_u, 0.0) / (double)(26 + bonus / 4), 1.0);
        int worldTime = (int)(this.field_70170_p.func_72820_D() % 24000L);
        noise *= Math.min((double)worldTime / 1000.0, 1.0);
        noise *= Math.min((double)Math.max(12000 - worldTime, 0) / 1000.0, 1.0);
        if (this.player.field_71093_bK != 0) {
            noise = 0.0;
        } else if (this.field_70170_p.func_72896_J() && !strong) {
            noise = biomeRain > 0.0f ? -0.5 : 0.0;
        }
        return noise;
    }

    public void func_70106_y() {
        super.func_70106_y();
        gliderMap.remove(this.player);
        if (this.varioControl.isValid()) {
            this.varioControl.kill();
            this.varioControl.release();
            this.ticksSinceLastVarioUpdate = 0;
            this.verticalMotionSinceLastVarioUpdate = 0.0;
        }
    }

    private void fixPositions(EntityPlayer thePlayer, boolean localPlayer) {
        this.field_70142_S = this.field_70169_q = this.player.field_70169_q;
        this.field_70137_T = this.field_70167_r = this.player.field_70167_r;
        this.field_70136_U = this.field_70166_s = this.player.field_70166_s;
        this.field_70165_t = this.player.field_70165_t;
        this.field_70163_u = this.player.field_70163_u;
        this.field_70161_v = this.player.field_70161_v;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70126_B = this.player.field_70760_ar;
        this.field_70177_z = this.player.field_70761_aq;
        this.field_70127_C = this.player.field_70127_C;
        this.field_70125_A = this.player.field_70125_A;
        this.field_70163_u += 1.2;
        this.field_70167_r += 1.2;
        this.field_70137_T += 1.2;
        this.field_70159_w = this.field_70165_t - this.field_70169_q;
        this.field_70181_x = this.field_70163_u - this.field_70167_r;
        this.field_70179_y = this.field_70161_v - this.field_70166_s;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public boolean func_70039_c(NBTTagCompound p_70039_1_) {
        return false;
    }
}

