/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openmods.block.OpenBlock;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Orientation;
import openmods.infobook.BookDocumentation;

@BookDocumentation
public class BlockXPShower
extends OpenBlock.FourDirections {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.4375, 0.4375, 0.4375, 0.5625, 0.5625, 1.0);
    public static final IProperty<Boolean> POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final int MASK_POWERED = 8;

    public BlockXPShower() {
        super(Material.field_151576_e);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
        this.setRequiresInitialization(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation(), POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | ((Boolean)state.func_177229_b(POWERED) != false ? 8 : 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        Orientation orientation = this.getOrientation(source, pos);
        return BlockSpaceTransform.instance.mapBlockToWorld(orientation, AABB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        switch (side) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return true;
            }
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos blockPos, Block neighbour, BlockPos neigbourPos) {
        BlockXPShower.updateRedstone(world, blockPos, state);
        super.func_189540_a(state, world, blockPos, neighbour, neigbourPos);
    }

    protected boolean onBlockAddedNextTick(World world, BlockPos blockPos, IBlockState state) {
        BlockXPShower.updateRedstone(world, blockPos, state);
        return super.onBlockAddedNextTick(world, blockPos, state);
    }

    private static void updateRedstone(World world, BlockPos blockPos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        boolean isPowered = world.func_175687_A(blockPos) > 0;
        IBlockState newState = state.func_177226_a(POWERED, (Comparable)Boolean.valueOf(isPowered));
        if (state != newState) {
            world.func_180501_a(blockPos, newState, 3);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

