/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.item;

import com.jaquadro.minecraft.chameleon.resources.IItemEnum;
import com.jaquadro.minecraft.chameleon.resources.IItemMeshMapper;
import com.jaquadro.minecraft.chameleon.resources.IItemVariantProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class ChamMultiItemBlock<T extends Enum<T>>
extends ItemBlock
implements IItemMeshMapper,
IItemVariantProvider {
    private final Class<T> clazz;
    private final IntFunction<T> metaLookup;
    private final PropertyEnum<T> property;

    public ChamMultiItemBlock(Block block, PropertyEnum<T> property, Class<T> clazz, IntFunction<T> metaLookup) {
        super(block);
        this.property = property;
        this.clazz = clazz;
        this.metaLookup = metaLookup;
        this.setRegistryName(block.getRegistryName());
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack itemStack) {
        Enum material = (Enum)this.metaLookup.apply(itemStack.func_77960_j());
        return super.func_77658_a() + "." + ((IItemEnum)((Object)material)).getUnlocalizedName();
    }

    @Override
    public List<Pair<ItemStack, ModelResourceLocation>> getMeshMappings() {
        ArrayList<Pair<ItemStack, ModelResourceLocation>> mappings = new ArrayList<Pair<ItemStack, ModelResourceLocation>>();
        for (Enum entry : (Enum[])this.clazz.getEnumConstants()) {
            IBlockState state = this.field_150939_a.func_176223_P().func_177226_a(this.property, (Comparable)((Object)entry));
            ModelResourceLocation location = new ModelResourceLocation(this.field_150939_a.getRegistryName().toString() + '_' + ((IStringSerializable)entry).func_176610_l(), "inventory");
            mappings.add((Pair<ItemStack, ModelResourceLocation>)Pair.of((Object)new ItemStack((Item)this, 1, this.field_150939_a.func_176201_c(state)), (Object)location));
        }
        return mappings;
    }

    @Override
    public List<ResourceLocation> getItemVariants() {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this);
        ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        for (Enum entry : (Enum[])this.clazz.getEnumConstants()) {
            variants.add(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + '_' + ((IStringSerializable)entry).func_176610_l()));
        }
        return variants;
    }
}

