/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.quarry;

import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.particles.ParticleSplineDot;
import com.rwtema.extrautils2.quarry.TileQuarry;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.XURandom;
import com.rwtema.extrautils2.utils.helpers.VecHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockQuarry
extends XUBlockStatic {
    public BlockQuarry() {
        this.func_149715_a(1.0f);
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        return BoxModel.newStandardBlock("quantum_quarry");
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(Lang.translate("Mine blocks from a hypothetical dimension that might have existed"));
        tooltip.add(Lang.translate("Requires Actuators to be attached to all sides"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileQuarry && ((TileQuarry)tileEntity).hasNearbyBlocks() && rand.nextBoolean()) {
            EnumFacing facing2;
            EnumFacing facing1 = XURandom.getRandomElement(EnumFacing.values());
            do {
                facing2 = XURandom.getRandomElement(EnumFacing.values());
            } while (facing1.func_176740_k() == facing2.func_176740_k());
            float c = rand.nextFloat();
            Vec3d p = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
            double speed = 5.0;
            double speed2 = 2.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSplineDot(worldIn, VecHelper.addSide(p, facing1, 1.5), VecHelper.addSide(p, facing2, 1.5), VecHelper.addSide(Vec3d.field_186680_a, facing1, speed).func_72441_c(rand.nextGaussian() * speed2, rand.nextGaussian() * speed2, rand.nextGaussian() * speed2), VecHelper.addSide(Vec3d.field_186680_a, facing2, -speed).func_72441_c(rand.nextGaussian() * speed2, rand.nextGaussian() * speed2, rand.nextGaussian() * speed2), c * 0.1882353f, 1.0f, 0.9843137f - c * 0.1882353f, 100));
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileQuarry();
    }
}

