/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.modcompat;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.particles.ParticleWithering;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.XURandom;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ranged.IAmmo;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class XUTrait
extends AbstractTrait {
    public XUTrait(String identifier, TextFormatting color, String name, @Nullable String tooltip) {
        super(identifier, color);
        this.register(name, tooltip);
    }

    public XUTrait(String identifier, int color, String name, @Nullable String tooltip) {
        super(identifier, color);
        this.register(name, tooltip);
    }

    public static boolean hasTrait(Entity entity, ITrait trait) {
        for (ItemStack stack : entity.func_184214_aD()) {
            if (!XUTrait.hasTrait(stack, trait)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTrait(ItemStack tool, ITrait trait) {
        if (tool.func_77973_b() instanceof ToolCore && !ToolHelper.isBroken((ItemStack)tool)) {
            NBTTagList list = TagUtil.getTraitsTagList((ItemStack)tool);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait toolTrait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                if (toolTrait != trait) continue;
                return true;
            }
        }
        return false;
    }

    public void register(String name, @Nullable String tooltip) {
        Lang.translate(String.format("modifier.%s.name", this.getIdentifier()), name);
        if (tooltip != null) {
            Lang.translate(String.format("modifier.%s.desc", this.getIdentifier()), tooltip);
        }
    }

    public static class TraitExperience
    extends XUTrait {
        private final int MULTIPLIER = 4;

        public TraitExperience() {
            super("xu_xp_boost", -3866737, "Experience Boost", "Gives bonus XP when mining or slaying mobs.");
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onLivDie(LivingExperienceDropEvent event) {
            if (event.getAttackingPlayer() != null && TraitExperience.hasTrait((Entity)event.getAttackingPlayer(), (ITrait)this)) {
                event.setDroppedExperience(event.getDroppedExperience() * 4);
            }
        }

        @SubscribeEvent
        public void onMine(BlockEvent.BreakEvent event) {
            if (TraitExperience.hasTrait((Entity)event.getPlayer(), (ITrait)this)) {
                event.setExpToDrop(event.getExpToDrop() * 4);
            }
        }

        public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
            return ImmutableList.of((Object)Lang.translateArgs(false, String.format("modifier.%s.extra", this.getIdentifier()), "Gives %s XP boost", StringHelper.formatPercent(4.0)));
        }
    }

    public static class TraitWitherHead
    extends XUTrait {
        public static final int ATTACK_COST = 10;

        public TraitWitherHead() {
            super("xu_wither_heads", -13355980, "Wither Head Launcher", "Right click to launch Wither Heads at things!");
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onClick(PlayerInteractEvent.RightClickItem event) {
            ItemStack tool = event.getItemStack();
            if (event.getWorld().field_72995_K) {
                return;
            }
            if (tool.func_77973_b() instanceof ToolCore && !ToolHelper.isBroken((ItemStack)tool)) {
                int startDurability;
                if (ToolHelper.isBroken((ItemStack)tool) || (startDurability = ToolHelper.getCurrentDurability((ItemStack)tool)) < 10) {
                    return;
                }
                NBTTagList list = TagUtil.getTraitsTagList((ItemStack)tool);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                    if (trait != this) continue;
                    EntityPlayer player = event.getEntityPlayer();
                    ToolHelper.damageTool((ItemStack)tool, (int)10, (EntityLivingBase)player);
                    int newDurability = ToolHelper.getCurrentDurability((ItemStack)tool);
                    World world = event.getWorld();
                    int ammountTaken = startDurability - newDurability;
                    if (ammountTaken == 0) {
                        return;
                    }
                    event.setCanceled(true);
                    if (world.field_73012_v.nextInt(10) >= ammountTaken) {
                        return;
                    }
                    float pitch = player.field_70125_A;
                    float yaw = player.field_70177_z;
                    float x = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                    float y = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
                    float z = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                    EntityWitherSkull entitywitherskull = new EntityWitherSkull(world, (EntityLivingBase)player, (double)(x * 10.0f), (double)(y * 10.0f), (double)(z * 10.0f));
                    entitywitherskull.field_70163_u = player.field_70163_u + (double)player.func_70047_e() - 0.1;
                    entitywitherskull.field_70165_t = player.field_70165_t;
                    entitywitherskull.field_70161_v = player.field_70161_v;
                    entitywitherskull.field_70125_A = pitch;
                    entitywitherskull.field_70177_z = yaw;
                    world.func_72838_d((Entity)entitywitherskull);
                    return;
                }
            }
        }
    }

    public static class TraitChatty
    extends XUTrait {
        private final int TIME_BETWEEN_MESSAGES = 600;
        int timeSinceLastMessage = XURandom.rand.nextInt(600);

        public TraitChatty() {
            super("xu_whispering", TextFormatting.DARK_RED, "Whispering", "Will occasionally whisper it's will to you");
        }

        @SideOnly(value=Side.CLIENT)
        public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
            if (!world.field_72995_K) {
                return;
            }
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            if (Minecraft.func_71410_x().field_71439_g != entity) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            --this.timeSinceLastMessage;
            if (this.timeSinceLastMessage < 0) {
                this.timeSinceLastMessage = 600 << 2 + player.field_70170_p.field_73012_v.nextInt(2400);
                if (!isSelected) {
                    return;
                }
                RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
                if (objectMouseOver != null && objectMouseOver.field_72313_a == RayTraceResult.Type.ENTITY && objectMouseOver.field_72308_g instanceof EntityPlayer) {
                    this.sendMessage(tool, player, (ITextComponent)Lang.chat("Kill!", new Object[0]));
                } else {
                    this.sendMessage(tool, player, (ITextComponent)CollectionHelper.getRandomElementMulti(Lang.chat("Time for death and destruction?", new Object[0]), Lang.chat("I'm hungry, feed me.", new Object[0]), Lang.chat("Hey you, let's go kill everything!", new Object[0]), Lang.chat("Murder! Death! Kill!", new Object[0]), Lang.chat("Hack n' slash! Hack n' slash! Hack n' slash! Hack n' slash! Hack n' slash!", new Object[0]), Lang.chat("Feast on their blood.", new Object[0]), Lang.chat("I feel... sharp.", new Object[0]), Lang.chat("I'm ready and willing.", new Object[0]), Lang.chat("Stabby stabby stab!.", new Object[0]), Lang.chat("Let the essence of life and death flow freely.", new Object[0]), Lang.chat("This world is filled with such life and beauty. Let's go destroy it all.", new Object[0])));
                }
            }
        }

        private void sendMessage(ItemStack tool, EntityPlayer player, ITextComponent message) {
            TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("commands.message.display.incoming", new Object[]{tool.func_82833_r(), message});
            textcomponenttranslation.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.TRUE);
            player.func_145747_a((ITextComponent)textcomponenttranslation);
        }
    }

    public static class TraitWithering
    extends XUTrait {
        static final int INNER_RANGE = 64;
        static final int OUTER_RANGE = 900;
        WeakHashMap<EntityPlayerMP, Integer> players = new WeakHashMap();

        public TraitWithering() {
            super("xu_withering", -13355980, "Evil Aura", "When held, creates an aura of evil that brings misfortune to the wielder.");
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void spawnOverride(LivingSpawnEvent.CheckSpawn event) {
            if (this.players.isEmpty()) {
                return;
            }
            World world = event.getWorld();
            if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                return;
            }
            if (world.field_73012_v.nextInt(40) != 0) {
                return;
            }
            EntityLiving entityLiving = (EntityLiving)event.getEntityLiving();
            if (!(entityLiving instanceof IMob)) {
                return;
            }
            for (EntityPlayerMP player : this.players.keySet()) {
                double distanceSqToEntity = entityLiving.func_70068_e((Entity)player);
                if (!(distanceSqToEntity < 900.0) || !(distanceSqToEntity > 64.0)) continue;
                if (!entityLiving.func_70058_J()) {
                    return;
                }
                if (world.field_73012_v.nextInt(20) != 0) {
                    return;
                }
                IBlockState iblockstate = world.func_180495_p(new BlockPos((Entity)entityLiving).func_177977_b());
                if (!iblockstate.func_189884_a((Entity)entityLiving)) {
                    return;
                }
                entityLiving.func_70624_b((EntityLivingBase)player);
                event.setResult(Event.Result.ALLOW);
                return;
            }
        }

        public void onUpdate(ItemStack tool, World world, final Entity entity, int itemSlot, boolean isSelected) {
            if (!isSelected && !(tool.func_77973_b() instanceof IAmmo)) {
                return;
            }
            if (!world.field_72995_K && entity instanceof EntityPlayerMP && !(entity instanceof FakePlayer)) {
                Item itemDropped;
                BlockPos down;
                IBlockState blockState;
                if (world.field_73012_v.nextInt(4) == 0 && (blockState = world.func_180495_p(down = new BlockPos(entity).func_177977_b())) != Blocks.field_150346_d.func_176223_P() && (blockState.func_185904_a() == Material.field_151577_b || blockState.func_185904_a() == Material.field_151578_c) && (itemDropped = blockState.func_177230_c().func_180660_a(blockState, random, 0)) == Item.func_150898_a((Block)Blocks.field_150346_d)) {
                    world.func_175656_a(down, Blocks.field_150346_d.func_176223_P());
                }
                this.players.put((EntityPlayerMP)entity, 10);
            } else if (world.field_72995_K) {
                ExtraUtils2.proxy.run(new ClientRunnable(){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void run() {
                        AxisAlignedBB entityBoundingBox = entity.func_174813_aQ();
                        Random rand = entity.field_70170_p.field_73012_v;
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleWithering(entity.field_70170_p, entityBoundingBox.field_72340_a + (entityBoundingBox.field_72336_d - entityBoundingBox.field_72340_a) * (double)rand.nextFloat(), entityBoundingBox.field_72338_b + (entityBoundingBox.field_72337_e - entityBoundingBox.field_72338_b) * (double)rand.nextFloat() * (double)0.2f, entityBoundingBox.field_72339_c + (entityBoundingBox.field_72334_f - entityBoundingBox.field_72339_c) * (double)rand.nextFloat()));
                    }
                });
            }
        }

        @SubscribeEvent
        public void onTick(TickEvent.ServerTickEvent event) {
            if (this.players.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<EntityPlayerMP, Integer>> iterator = this.players.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<EntityPlayerMP, Integer> next = iterator.next();
                int value = next.getValue() - 1;
                if (value <= 0) {
                    iterator.remove();
                    continue;
                }
                next.setValue(value);
            }
        }

        public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
            if (entity instanceof FakePlayer) {
                ToolHelper.breakTool((ItemStack)tool, null);
            }
            return super.onToolDamage(tool, damage, newDamage, entity);
        }
    }

    public static class TraitBrittle
    extends XUTrait {
        public TraitBrittle() {
            super("brittle", -9874381, "Brittle", "Has a random chance of breaking when it takes damage.");
        }

        public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
            boolean flag;
            int maxDurability = ToolHelper.getMaxDurability((ItemStack)tool);
            boolean bl = flag = maxDurability <= 1;
            if (!flag) {
                Random rand = entity.field_70170_p.field_73012_v;
                for (int i = 0; i < Math.max(1, damage); ++i) {
                    if (rand.nextInt(Math.max(100, maxDurability * maxDurability)) != 0) continue;
                    flag = true;
                    break;
                }
            }
            if (flag) {
                ToolHelper.breakTool((ItemStack)tool, (EntityLivingBase)entity);
            }
            return super.onToolDamage(tool, damage, newDamage, entity);
        }
    }

    public static class TraitMagicalModifiers
    extends XUTrait {
        public TraitMagicalModifiers() {
            super("magical_modifier", -5263441, "Magically Modifiable", "Adds 3 extra modifiers to a tool");
        }

        public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
            super.applyEffect(rootCompound, modifierTag);
            NBTTagList tagList = TagUtil.getModifiersTagList((NBTTagCompound)rootCompound);
            int index = TinkerUtil.getIndexInCompoundList((NBTTagList)tagList, (String)this.getModifierIdentifier());
            NBTTagCompound tag = new NBTTagCompound();
            if (index > -1) {
                tag = tagList.func_150305_b(index);
            } else {
                index = tagList.func_74745_c();
                tagList.func_74742_a((NBTBase)tag);
            }
            if (!tag.func_74767_n(this.identifier)) {
                tag.func_74757_a(this.identifier, true);
                tagList.func_150304_a(index, (NBTBase)tag);
                NBTTagCompound toolTag = TagUtil.getToolTag((NBTTagCompound)rootCompound);
                int modifiers = toolTag.func_74762_e("FreeModifiers") + 3;
                toolTag.func_74768_a("FreeModifiers", Math.max(0, modifiers));
                TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)toolTag);
            }
        }
    }
}

