/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.blocks.BlockTerraformer;
import com.rwtema.extrautils2.crafting.jei.XUJEIPlugin;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.items.itemmatching.IMatcherMaker;
import com.rwtema.extrautils2.tile.TileTerraformer;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class JEITerraformerHandler
extends BlankRecipeCategory<Wrapper>
implements IRecipeHandler<Holder> {
    public static final String uid = "extrautils2.terraformer";
    public static final int recipeWidth = 116;
    public static final int recipeheight = 52;
    public static final int arrowX = 47;
    public static final int slotX0 = 25;
    public static final int slotX1 = 75;
    public static final int arrowY = 17;
    public static final int y0 = 0;
    public static final int y1 = 17;
    public static final int y2 = 35;
    IDrawable slotDrawable = XUJEIPlugin.jeiHelpers.getGuiHelper().getSlotDrawable();
    IDrawable background = XUJEIPlugin.jeiHelpers.getGuiHelper().createBlankDrawable(116, 52);
    IDrawable arrowBack = XUJEIPlugin.jeiHelpers.getGuiHelper().createDrawable(DynamicGui.texWidgets, 98, 0, 22, 16);

    @Nonnull
    public String getUid() {
        return uid;
    }

    @Nonnull
    public String getTitle() {
        return TileTerraformer.getName(BlockTerraformer.Type.CONTROLLER);
    }

    public String getModName() {
        return "extrautils2";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull Wrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 25, 0);
        guiItemStacks.set(0, TileTerraformer.getStack(BlockTerraformer.Type.ANTENNA));
        guiItemStacks.init(1, true, 25, 17);
        guiItemStacks.set(1, (List)ImmutableList.copyOf(recipeWrapper.holder.stack.getSubItems()));
        guiItemStacks.init(2, true, 25, 35);
        guiItemStacks.set(2, TileTerraformer.getStack(recipeWrapper.holder.type));
    }

    @Nonnull
    public Class<Holder> getRecipeClass() {
        return Holder.class;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return uid;
    }

    @Nonnull
    public String getRecipeCategoryUid(@Nonnull Holder recipe) {
        return uid;
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull Holder recipe) {
        return new Wrapper(recipe);
    }

    public boolean isRecipeValid(@Nonnull Holder recipe) {
        return !recipe.stack.getSubItems().isEmpty();
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.slotDrawable.draw(minecraft, 25, 17);
        this.arrowBack.draw(minecraft, 47, 17);
    }

    public static class Wrapper
    extends BlankRecipeWrapper
    implements IRecipeWrapper {
        final Holder holder;

        public Wrapper(Holder holder) {
            this.holder = holder;
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputLists(ItemStack.class, (List)ImmutableList.of((Object)ImmutableList.of((Object)TileTerraformer.getStack(BlockTerraformer.Type.ANTENNA)), (Object)ImmutableList.copyOf(this.holder.stack.getSubItems()), (Object)ImmutableList.of((Object)TileTerraformer.getStack(this.holder.type))));
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            minecraft.field_71466_p.func_78276_b(StringHelper.format(this.holder.amount) + " TF", 75, 22, Color.gray.getRGB());
        }
    }

    public static class Holder {
        final BlockTerraformer.Type type;
        final IMatcherMaker stack;
        final int amount;

        public Holder(BlockTerraformer.Type type, IMatcherMaker stack, int amount) {
            this.type = type;
            this.stack = stack;
            this.amount = amount;
        }
    }
}

