/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.PassthruModelBlock;
import com.rwtema.extrautils2.backend.model.Transforms;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class XUBlockStatic
extends XUBlock {
    public final HashMap<IBlockState, EnumSet<BlockRenderLayer>> layerMap = new HashMap(1, 0.2f);
    public final HashMap<IBlockState, BoxModel> cachedModels = new HashMap<IBlockState, BoxModel>(){

        @Override
        public BoxModel get(Object key) {
            BoxModel boxes = (BoxModel)super.get(key);
            if (boxes == null || XUBlockStatic.recalc_models()) {
                IBlockState state = key != null ? (IBlockState)key : XUBlockStatic.this.func_176223_P();
                boxes = XUBlockStatic.this.getModel(state);
                super.put(state, boxes);
            }
            return boxes;
        }
    };
    public final HashMap<IBlockState, BoxModel> cachedInvModels = new HashMap<IBlockState, BoxModel>(){

        @Override
        public BoxModel get(Object key) {
            BoxModel boxes = (BoxModel)super.get(key);
            if (boxes == null || XUBlockStatic.recalc_models()) {
                IBlockState state = key != null ? (IBlockState)key : XUBlockStatic.this.func_176223_P();
                boxes = XUBlockStatic.this.getModelInv(state);
                boxes.moveToCenterForInventoryRendering();
                super.put(state, boxes);
            }
            return boxes;
        }
    };

    public XUBlockStatic(Material materialIn, MapColor color) {
        super(materialIn, color);
    }

    public XUBlockStatic(Material materialIn) {
        super(materialIn);
    }

    public XUBlockStatic() {
    }

    public static boolean recalc_models() {
        return ExtraUtils2.deobf_folder;
    }

    public static <K, V> HashMap<K, V> dummyCreateHash(Object s) {
        return new HashMap();
    }

    @Override
    public void registerTextures() {
        for (IBlockState iBlockState : this.xuBlockState.func_177619_a()) {
            this.cachedModels.get(iBlockState).registerTextures();
        }
    }

    @Override
    public void clearCaches() {
        this.cachedModels.clear();
        this.cachedInvModels.clear();
        this.layerMap.clear();
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        return this.cachedModels.get(state == null ? world.func_180495_p(pos) : state);
    }

    @Override
    public BoxModel getGenericWorldModel(IBlockState state) {
        if (this.cachedModels == null) {
            return this.getModel(state);
        }
        return super.getGenericWorldModel(state);
    }

    @Override
    @Nonnull
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return this.cachedInvModels.get((Object)this.xuBlockState.getStateFromItemStack(item));
    }

    public BoxModel getModelInv(IBlockState state) {
        return this.getModel(state);
    }

    public abstract BoxModel getModel(IBlockState var1);

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, @Nonnull BlockRenderLayer layer) {
        EnumSet<BlockRenderLayer> set = this.layerMap.get(state);
        if (set == null) {
            set = EnumSet.noneOf(BlockRenderLayer.class);
            for (Box box : this.cachedModels.get(state)) {
                set.add(box.layer);
            }
            this.layerMap.put(state, set);
        }
        return set.contains(layer);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxBase(IBlockState state, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos) {
        return this.cachedModels.get(state).getAABB(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public PassthruModelBlock createPassthruModel(IBlockState state, ModelResourceLocation location) {
        return new PassthruModelBlock(this, state, location){
            HashMap<IBlockState, HashMap<EnumFacing, HashMap<BlockRenderLayer, List<BakedQuad>>>> cachedLists;
            {
                this.cachedLists = new HashMap();
            }

            @Override
            @Nonnull
            @SideOnly(value=Side.CLIENT)
            public List<BakedQuad> func_188616_a(final IBlockState state, final EnumFacing side, final long rand) {
                return this.cachedLists.computeIfAbsent(state, XUBlockStatic::dummyCreateHash).computeIfAbsent(side, XUBlockStatic::dummyCreateHash).computeIfAbsent(MinecraftForgeClient.getRenderLayer(), new Function<BlockRenderLayer, List<BakedQuad>>(){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public List<BakedQuad> apply(BlockRenderLayer layer) {
                        MutableModel model = new MutableModel(Transforms.blockTransforms);
                        XUBlockStatic.this.cachedModels.get(state).loadIntoMutable(model, layer);
                        return model.func_188616_a(state, side, rand);
                    }
                });
            }
        };
    }

    @Override
    public boolean allowOverride() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public MutableModel recreateNewInstance(MutableModel result) {
        return result;
    }
}

