/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletObjectMapping;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.items.GenericRFToolsItem;
import mcjty.rftoolsdim.network.PacketGetDimensionEnergy;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RealizedDimensionTab
extends GenericRFToolsItem {
    private static long lastTime = 0L;

    public RealizedDimensionTab() {
        super("realized_dimension_tab");
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af()) {
            RfToolsDimensionManager dimensionManager;
            DimensionInformation information;
            NBTTagCompound tagCompound = stack.func_77978_p();
            Logging.message((EntityPlayer)player, (String)tagCompound.func_74779_i("descriptionString"));
            int id = tagCompound.func_74762_e("id");
            if (id != 0 && (information = (dimensionManager = RfToolsDimensionManager.getDimensionManager(world)).getDimensionInformation(id)) != null) {
                information.dump(player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, world, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String name = tagCompound.func_74779_i("name");
            int id = 0;
            if (name != null) {
                id = tagCompound.func_74762_e("id");
                if (id == 0) {
                    list.add(TextFormatting.BLUE + "Name: " + name);
                } else {
                    list.add(TextFormatting.BLUE + "Name: " + name + " (Id " + id + ")");
                }
            }
            String descriptionString = tagCompound.func_74779_i("descriptionString");
            this.constructDescriptionHelp(list, descriptionString);
            Integer ticksLeft = tagCompound.func_74762_e("ticksLeft");
            if (ticksLeft == 0) {
                DimensionInformation information = RfToolsDimensionManager.getDimensionManagerClient().getDimensionInformation(id);
                if (information == null) {
                    list.add(TextFormatting.RED + "Dimension information Missing!");
                } else {
                    list.add(TextFormatting.BLUE + "Dimension ready!");
                    int maintainCost = tagCompound.func_74762_e("rfMaintainCost");
                    int actualCost = information.getActualRfCost();
                    if (actualCost == maintainCost || actualCost == 0) {
                        list.add(TextFormatting.YELLOW + "    Maintenance cost: " + maintainCost + " RF/tick");
                    } else {
                        list.add(TextFormatting.YELLOW + "    Maintenance cost: " + actualCost + " RF/tick (Specified: " + maintainCost + " RF/tick)");
                    }
                    if (id != 0) {
                        if (System.currentTimeMillis() - lastTime > 500L) {
                            lastTime = System.currentTimeMillis();
                            RFToolsDimMessages.INSTANCE.sendToServer((IMessage)new PacketGetDimensionEnergy(id));
                        }
                        DimensionStorage storage = DimensionStorage.getDimensionStorage(world);
                        long power = storage.getEnergyLevel(id);
                        list.add(TextFormatting.YELLOW + "    Current power: " + power + " RF");
                    }
                }
            } else {
                int createCost = tagCompound.func_74762_e("rfCreateCost");
                int maintainCost = tagCompound.func_74762_e("rfMaintainCost");
                int tickCost = tagCompound.func_74762_e("tickCost");
                int percentage = (tickCost - ticksLeft) * 100 / tickCost;
                list.add(TextFormatting.BLUE + "Dimension progress: " + percentage + "%");
                list.add(TextFormatting.YELLOW + "    Creation cost: " + createCost + " RF/tick");
                list.add(TextFormatting.YELLOW + "    Maintenance cost: " + maintainCost + " RF/tick");
                list.add(TextFormatting.YELLOW + "    Tick cost: " + tickCost + " ticks");
            }
        }
    }

    private void constructDescriptionHelp(List<String> list, String descriptionString) {
        DimletType type;
        HashMap dimletTypeListMap = new HashMap();
        for (DimletKey dimletKey : DimensionDescriptor.parseDescriptionString(descriptionString)) {
            type = dimletKey.getType();
            if (!dimletTypeListMap.containsKey((Object)type)) {
                dimletTypeListMap.put(type, new ArrayList());
            }
            ((List)dimletTypeListMap.get((Object)dimletKey.getType())).add(dimletKey);
        }
        for (Map.Entry entry : dimletTypeListMap.entrySet()) {
            type = (DimletType)((Object)entry.getKey());
            List keys = (List)entry.getValue();
            if (keys == null || keys.isEmpty()) continue;
            if (type == DimletType.DIMLET_DIGIT) {
                String digitString = "";
                for (DimletKey key : keys) {
                    digitString = digitString + DimletObjectMapping.getDigit(key);
                }
                list.add(TextFormatting.GREEN + "Digits " + digitString);
                continue;
            }
            if (keys.size() == 1) {
                list.add(TextFormatting.GREEN + type.dimletType.getName() + " 1 dimlet");
                continue;
            }
            list.add(TextFormatting.GREEN + type.dimletType.getName() + " " + keys.size() + " dimlets");
        }
    }
}

