/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.items;

import java.util.List;
import java.util.Set;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.items.GenericRFToolsItem;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class KnownDimlet
extends GenericRFToolsItem {
    public KnownDimlet() {
        super("known_dimlet");
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelResourceLocation[] models = new ModelResourceLocation[DimletType.values().length];
        int meta = 0;
        for (DimletType type : DimletType.values()) {
            models[meta] = new ModelResourceLocation(this.getRegistryName() + "_" + type.dimletType.getName().toLowerCase(), "inventory");
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{models[meta]});
            ++meta;
        }
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> models[stack.func_77952_i()]);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        DimletKey key = KnownDimletConfiguration.getDimletKey(stack);
        if (KnownDimletConfiguration.isSeedDimlet(key)) {
            boolean locked;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
            }
            if (locked = tagCompound.func_74767_n("locked")) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This seed dimlet is locked. You cannot modify it!"));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            long forcedSeed = tagCompound.func_74763_f("forcedSeed");
            if (player.func_70093_af()) {
                if (forcedSeed == 0L) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This dimlet has no seed. You cannot lock it!"));
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                tagCompound.func_74757_a("locked", true);
                Logging.message((EntityPlayer)player, (String)"Dimlet locked!");
            } else {
                long seed = world.func_72905_C();
                tagCompound.func_74772_a("forcedSeed", seed);
                Logging.message((EntityPlayer)player, (String)("Seed set to: " + seed));
            }
            stack.func_77982_d(tagCompound);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag showExtended) {
        super.func_77624_a(itemStack, player, list, showExtended);
        DimletKey key = KnownDimletConfiguration.getDimletKey(itemStack);
        Settings settings = KnownDimletConfiguration.getSettings(key);
        if (showExtended.func_194127_a()) {
            list.add(TextFormatting.GOLD + "Key: " + key.getId());
        }
        if (settings == null) {
            list.add(TextFormatting.WHITE + "Dimlet " + key.getType().dimletType.getName() + "." + key.getId());
            list.add(TextFormatting.RED + "This dimlet is blacklisted!");
            return;
        }
        list.add(TextFormatting.BLUE + "Rarity: " + settings.getRarity() + (KnownDimletConfiguration.isCraftable(key) ? " (craftable)" : ""));
        list.add(TextFormatting.YELLOW + "Create cost: " + settings.getCreateCost() + " RF/tick");
        int maintainCost = settings.getMaintainCost();
        if (maintainCost < 0) {
            list.add(TextFormatting.YELLOW + "Maintain cost: " + maintainCost + "% RF/tick");
        } else {
            list.add(TextFormatting.YELLOW + "Maintain cost: " + maintainCost + " RF/tick");
        }
        list.add(TextFormatting.YELLOW + "Tick cost: " + settings.getTickCost() + " ticks");
        if (KnownDimletConfiguration.isSeedDimlet(key)) {
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound != null && tagCompound.func_74763_f("forcedSeed") != 0L) {
                long forcedSeed = tagCompound.func_74763_f("forcedSeed");
                boolean locked = tagCompound.func_74767_n("locked");
                list.add(TextFormatting.BLUE + "Forced seed: " + forcedSeed + (locked ? " [LOCKED]" : ""));
            } else {
                list.add(TextFormatting.BLUE + "Right click to copy seed from dimension.");
                list.add(TextFormatting.BLUE + "Shift-Right click to lock copied seed.");
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            for (String info : key.getType().dimletType.getInformation()) {
                list.add(TextFormatting.WHITE + info);
            }
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        DimletType type = DimletType.values()[itemStack.func_77952_i()];
        return super.func_77667_c(itemStack) + "_" + type.dimletType.getName().toLowerCase();
    }

    public String func_77653_i(ItemStack stack) {
        DimletKey key = KnownDimletConfiguration.getDimletKey(stack);
        String displayName = super.func_77653_i(stack);
        if (key.getId() == null) {
            return displayName;
        }
        return displayName + " (" + KnownDimletConfiguration.getDisplayName(key) + ")";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            Set<DimletKey> dimlets = KnownDimletConfiguration.getCraftableDimlets();
            for (DimletKey key : dimlets) {
                subItems.add((Object)KnownDimletConfiguration.getDimletStack(key));
            }
        }
    }
}

