/*
 * Decompiled with CFR 0.152.
 */
package se.rupy.http;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.LinkedList;
import se.rupy.http.Event;
import se.rupy.http.Service;
import se.rupy.http.Session;

public class Chain
extends LinkedList {
    private int next;

    protected Link put(Link link) {
        for (int i = 0; i < this.size(); ++i) {
            Link tmp = (Link)super.get(i);
            if (link.index() == tmp.index()) {
                return this.set(i, link);
            }
            if (link.index() >= tmp.index()) continue;
            this.add(i, link);
            return null;
        }
        this.add(link);
        return null;
    }

    public void filter(final Event event) throws Event, Exception {
        for (int i = 0; i < this.size(); ++i) {
            final Service service = (Service)this.get(i);
            if (event.daemon().timeout > 0) {
                event.session(service);
            }
            if (event.daemon().host) {
                try {
                    Object o = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            try {
                                service.filter(event);
                                return null;
                            }
                            catch (Event event2) {
                                return event2;
                            }
                        }
                    }, event.daemon().archive(event.query().header("host")).access());
                    if (o == null) continue;
                    throw (Event)o;
                }
                catch (PrivilegedActionException e) {
                    if (e.getCause() != null) {
                        throw (Exception)e.getCause();
                    }
                    throw e;
                }
            }
            service.filter(event);
        }
    }

    protected void exit(final Session session, final int type) throws Exception {
        for (int i = 0; i < this.size(); ++i) {
            final Service service = (Service)this.get(i);
            if (session.daemon().host) {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        service.session(session, type);
                        return null;
                    }
                }, session.daemon().control);
                continue;
            }
            service.session(session, type);
        }
    }

    protected void reset() {
        this.next = 0;
    }

    protected Link next() {
        if (this.next >= this.size()) {
            this.next = 0;
            return null;
        }
        return (Link)this.get(this.next++);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.iterator();
        buffer.append('[');
        while (it.hasNext()) {
            Object object = it.next();
            String name = object.getClass().getName();
            if (name.equals("se.rupy.http.Event")) {
                buffer.append(object);
            } else {
                int dollar = name.lastIndexOf(36);
                int dot = name.lastIndexOf(46);
                if (dollar > 0) {
                    name = name.substring(dollar + 1);
                } else if (dot > 0) {
                    name = name.substring(dot + 1);
                }
                buffer.append(name);
            }
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    static interface Link {
        public int index();
    }
}

