/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.UUID;
import journeymap.common.feature.PlayerRadarManager;
import journeymap.common.network.impl.MessageProcessor;
import journeymap.common.network.impl.Response;
import journeymap.server.JourneymapServer;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class GetPlayerLocations
extends MessageProcessor {
    @Override
    protected JsonObject onServer(Response response) {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        boolean sendToEveryone = prop.playerTrackingEnabled.get();
        boolean sendToOps = prop.opPlayerTrackingEnabled.get();
        EntityPlayerMP player = response.getContext().getServerHandler().field_147369_b;
        boolean playerRadarEnabled = PropertiesManager.getInstance().getDimProperties((int)player.field_71093_bK).playerRadarEnabled.get();
        boolean receiverOp = JourneymapServer.isOp((EntityPlayer)player);
        if (sendToEveryone && playerRadarEnabled || sendToOps && receiverOp) {
            try {
                JsonObject update = new JsonObject();
                int updateTime = PropertiesManager.getInstance().getGlobalProperties().playerTrackingUpdateTime.get();
                boolean userTrack = PropertiesManager.getInstance().getGlobalProperties().playerTrackingEnabled.get();
                boolean opTrack = PropertiesManager.getInstance().getGlobalProperties().opPlayerTrackingEnabled.get();
                update.addProperty("can_track", Boolean.valueOf(userTrack || receiverOp && opTrack));
                update.addProperty("tracking_time", (Number)updateTime);
                this.sendPlayerTrackingData(player);
                return update;
            }
            catch (ConcurrentModificationException cme) {
                return null;
            }
        }
        return null;
    }

    private void sendPlayerTrackingData(EntityPlayerMP entityPlayerMP) {
        int receiverDimension = entityPlayerMP.field_71093_bK;
        boolean receiverOp = JourneymapServer.isOp((EntityPlayer)entityPlayerMP);
        ArrayList serverPlayers = new ArrayList(FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v());
        ArrayList<JsonObject> playerList = new ArrayList<JsonObject>();
        if (serverPlayers != null || serverPlayers.size() > 1) {
            for (EntityPlayerMP playerMp : serverPlayers) {
                boolean sneaking = playerMp.func_70093_af();
                int dimension = playerMp.field_71093_bK;
                UUID playerId = playerMp.func_110124_au();
                if (entityPlayerMP.func_110124_au().equals(playerId) || sneaking || receiverDimension != dimension) continue;
                playerList.add(this.buildJsonPlayer((EntityPlayer)playerMp, receiverOp));
            }
            if (serverPlayers.size() < 10) {
                this.sendPlayerList(playerList);
            }
        }
    }

    private void sendPlayerList(List<JsonObject> allPlayers) {
        List partitionedPlayerList = Lists.partition(allPlayers, (int)10);
        for (List playerList : partitionedPlayerList) {
            JsonArray playerArray = new JsonArray();
            for (JsonObject playerJsonObject : playerList) {
                playerArray.add((JsonElement)playerJsonObject);
            }
            JsonObject payload = new JsonObject();
            payload.add("players", (JsonElement)playerArray);
            new GetPlayerLocations().sendToPlayer(payload, (EntityPlayerMP)this.player);
        }
    }

    private JsonObject buildJsonPlayer(EntityPlayer playerMp, boolean receiverOp) {
        boolean sneaking = playerMp.func_70093_af();
        UUID playerId = playerMp.func_110124_au();
        if (receiverOp) {
            sneaking = false;
        }
        JsonObject player = new JsonObject();
        player.addProperty("name", playerMp.func_70005_c_());
        player.addProperty("posX", (Number)playerMp.func_180425_c().func_177958_n());
        player.addProperty("posY", (Number)playerMp.func_180425_c().func_177956_o());
        player.addProperty("posZ", (Number)playerMp.func_180425_c().func_177952_p());
        player.addProperty("chunkX", (Number)playerMp.field_70176_ah);
        player.addProperty("chunkY", (Number)playerMp.field_70162_ai);
        player.addProperty("chunkZ", (Number)playerMp.field_70164_aj);
        player.addProperty("rotation", (Number)Float.valueOf(playerMp.field_70759_as));
        player.addProperty("sneaking", Boolean.valueOf(sneaking));
        player.addProperty("playerId", playerId.toString());
        return player;
    }

    @Override
    protected JsonObject onClient(Response result) {
        if (result.getAsJson().get("players") != null) {
            JsonArray playerList = result.getAsJson().get("players").getAsJsonArray();
            PlayerRadarManager.getInstance().updatePlayers(playerList);
        }
        return null;
    }
}

