/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.world;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.StrataLayer;
import exterminatorjeff.undergroundbiomes.api.UBBiome;
import exterminatorjeff.undergroundbiomes.api.UndergroundBiomeSet;
import exterminatorjeff.undergroundbiomes.api.common.UBSettings;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.world.StrataLayers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public final class UBBiomesSet
extends UndergroundBiomeSet {
    private final UBSettings settings;
    private final UBBiome[] biomes;
    private final List<UBBiome> biomesBuilder = new ArrayList<UBBiome>();
    private int ID = 0;
    private UBBiome[] allowedBiomes;

    public UBBiomesSet(UBSettings settings) {
        super(new StrataLayers((UBSettings)settings).layers);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 0), this.strataLayers[0]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 1), this.strataLayers[1]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 2), this.strataLayers[2]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 3), this.strataLayers[3]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 4), this.strataLayers[4]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 5), this.strataLayers[5]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 6), this.strataLayers[6]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 7), this.strataLayers[7]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 0), this.strataLayers[8]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 1), this.strataLayers[9]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 2), this.strataLayers[0]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 3), this.strataLayers[1]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 4), this.strataLayers[2]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 5), this.strataLayers[3]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 6), this.strataLayers[4]);
        this.add(new UBBiome(this.ID, API.IGNEOUS_STONE, 7), this.strataLayers[5]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 0), this.strataLayers[6]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 1), this.strataLayers[7]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 2), this.strataLayers[8]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 3), this.strataLayers[9]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 4), this.strataLayers[0]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 5), this.strataLayers[1]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 6), this.strataLayers[2]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 7), this.strataLayers[3]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 0), this.strataLayers[4]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 1), this.strataLayers[5]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 2), this.strataLayers[6]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 3), this.strataLayers[7]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 4), this.strataLayers[8]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 5), this.strataLayers[9]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 6), this.strataLayers[0]);
        this.add(new UBBiome(this.ID, API.METAMORPHIC_STONE, 7), this.strataLayers[1]);
        if (settings.regularStoneBiomes() && UBConfig.SPECIFIC.generationAllowed(Blocks.field_150348_b.func_176223_P())) {
            this.add(new UBBiome(this.ID, Blocks.field_150348_b, 0), this.strataLayers[0]);
            this.add(new UBBiome(this.ID, Blocks.field_150348_b, 0), this.strataLayers[1]);
            this.add(new UBBiome(this.ID, Blocks.field_150348_b, 0), this.strataLayers[2]);
            this.add(new UBBiome(this.ID, Blocks.field_150348_b, 0), this.strataLayers[3]);
        }
        this.biomes = new UBBiome[this.biomesBuilder.size()];
        this.biomesBuilder.toArray(this.biomes);
        if (this.biomes[20].ID == 0) {
            throw new RuntimeException();
        }
        this.settings = settings;
        this.allowedBiomes = this.generatable(this.biomes);
    }

    private void add(UBBiome biome, StrataLayer[] layers) {
        if (UBConfig.SPECIFIC.generationAllowed(biome.filler)) {
            biome.addStrataLayers(layers);
            this.biomesBuilder.add(biome);
            ++this.ID;
        }
    }

    public UBBiome[] generatable(UBBiome[] possible) {
        ArrayList<UBBiome> accepted = new ArrayList<UBBiome>();
        for (int i = 0; i < possible.length; ++i) {
            IBlockState block = possible[i].filler;
            if (!this.settings.generationAllowed(block)) continue;
            accepted.add(possible[i]);
        }
        UBBiome[] result = new UBBiome[accepted.size()];
        return accepted.toArray(result);
    }

    @Override
    public UBBiome[] allowedBiomes() {
        return this.allowedBiomes;
    }
}

