/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.config;

import exterminatorjeff.undergroundbiomes.config.UBConfig;
import java.io.File;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigManager {
    public static final String CONFIG_DIRECTORY = "worldSpecificConfig";
    private File generalConfigFile;
    private UBConfig masterSettings;
    private UBConfig generalSettings;
    private File worldConfigFile;
    private UBConfig worldSpecific;

    public ConfigManager(FMLPreInitializationEvent event) {
        this(new UBConfig(), event.getSuggestedConfigurationFile());
    }

    public ConfigManager(UBConfig settings, File generalFile) {
        this.masterSettings = settings;
        this.generalConfigFile = generalFile;
        this.generalSettings = new UBConfig();
        this.generalSettings.init(this.generalConfigFile);
        this.masterSettings.init(this.generalConfigFile);
        UBConfig.SPECIFIC = this.masterSettings;
    }

    private boolean usable(File tested) {
        return tested != null;
    }

    public void saveWorldSpecific() {
        this.worldSpecific.save();
    }

    private void setWorldConfigFile(File newFile) {
        this.generalSettings = new UBConfig();
        this.generalSettings.init(this.generalConfigFile);
        if (this.worldConfigFile == null || !newFile.getAbsolutePath().equals(this.worldConfigFile.getAbsolutePath())) {
            this.worldConfigFile = newFile;
            if (this.usable(this.worldConfigFile)) {
                if (newFile.exists()) {
                    this.worldSpecific = new UBConfig();
                    this.worldSpecific.init(this.worldConfigFile);
                } else {
                    this.worldSpecific = new UBConfig();
                    this.worldSpecific.init(this.worldConfigFile);
                    this.worldSpecific.copy(this.generalSettings);
                }
                this.masterSettings.copy(this.worldSpecific);
                this.worldSpecific.save();
            } else {
                this.worldSpecific = null;
            }
        }
    }

    public void setWorldFile(File newFile) {
        File configDirectory = new File(newFile, CONFIG_DIRECTORY);
        configDirectory.mkdir();
        String configName = this.generalConfigFile.getPath();
        String generalConfigDirectoryName = this.generalConfigFile.getParentFile().getPath();
        String detailName = configName.substring(generalConfigDirectoryName.length() + 1);
        File localConfigFile = new File(configDirectory, detailName);
        this.setWorldConfigFile(localConfigFile);
    }

    public void clearWorldFile() {
        this.worldConfigFile = null;
        this.worldSpecific = null;
    }

    public void setWorldFile(WorldServer server) {
        this.setWorldFile(server.getChunkSaveLocation());
    }
}

