/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.api.names;

import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public abstract class Entry<T extends IForgeRegistryEntry<?>> {
    protected static final UBLogger LOGGER = new UBLogger(Entry.class, Level.INFO);
    protected final String internalName;
    private boolean isItemRegistered = false;
    private T thing;

    public Entry(String internalName) {
        this.internalName = internalName;
    }

    public boolean isRegistered() {
        return this.thing != null;
    }

    public boolean isItemRegistered() {
        return this.thing != null;
    }

    protected final T getThing() {
        if (this.thing == null) {
            LOGGER.warn("This entry '" + this.internalName + "' is not registered!");
        }
        return this.thing;
    }

    public final void registerItem(RegistryEvent.Register<Item> event, T thing) {
        if (this.thing == null || !this.isItemRegistered) {
            if (this.thing == null) {
                this.thing = thing;
            }
        } else {
            throw new RuntimeException("This entry is already registered! (" + this.internalName + ")");
        }
        this.isItemRegistered = true;
        this.doRegisterItem((IForgeRegistry<Item>)event.getRegistry());
        LOGGER.debug("Registering item '" + this.thing.getRegistryName() + "' for entry '" + this.internalName + "'");
    }

    public final void registerBlock(RegistryEvent.Register<Block> event, T thing) {
        if (this.thing != null) {
            throw new RuntimeException("This entry is already registered! (" + this.internalName + ")");
        }
        this.thing = thing;
        this.doRegisterBlock((IForgeRegistry<Block>)event.getRegistry());
        LOGGER.debug("Registering '" + this.thing.getRegistryName() + "' for entry '" + this.internalName + "'");
    }

    protected abstract void doRegisterItem(IForgeRegistry<Item> var1);

    protected abstract void doRegisterBlock(IForgeRegistry<Block> var1);

    public final void registerModel(IStateMapper stateMapper) {
        if (this.thing != null) {
            if (stateMapper != null) {
                LOGGER.debug("Registering models for entry '" + this.internalName + "' with custom state mapper");
            } else {
                LOGGER.debug("Registering models for entry '" + this.internalName + "'");
            }
            this.doRegisterModel(stateMapper);
        }
    }

    protected abstract void doRegisterModel(IStateMapper var1);

    protected static String externalName(String internalName) {
        return "undergroundbiomes:" + internalName;
    }
}

