/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.block;

import buildcraft.api.blocks.ICustomPaintHandler;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.EnumWirePart;
import buildcraft.api.transport.IItemPluggable;
import buildcraft.api.transport.WireNode;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.block.BlockBCTile_Neptune;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.SpriteUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.prop.UnlistedNonNullProperty;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.client.model.PipeModelCacheBase;
import buildcraft.transport.client.model.PipeModelCachePluggable;
import buildcraft.transport.client.render.PipeWireRenderer;
import buildcraft.transport.item.ItemWire;
import buildcraft.transport.pipe.Pipe;
import buildcraft.transport.tile.TilePipeHolder;
import buildcraft.transport.wire.EnumWireBetween;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPipeHolder
extends BlockBCTile_Neptune
implements ICustomPaintHandler {
    public static final IUnlistedProperty<WeakReference<TilePipeHolder>> PROP_TILE = new UnlistedNonNullProperty<WeakReference<TilePipeHolder>>("tile");
    private static final AxisAlignedBB BOX_CENTER = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    private static final AxisAlignedBB BOX_DOWN = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75);
    private static final AxisAlignedBB BOX_UP = new AxisAlignedBB(0.25, 0.75, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB BOX_NORTH = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.25);
    private static final AxisAlignedBB BOX_SOUTH = new AxisAlignedBB(0.25, 0.25, 0.75, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB BOX_WEST = new AxisAlignedBB(0.0, 0.25, 0.25, 0.25, 0.75, 0.75);
    private static final AxisAlignedBB BOX_EAST = new AxisAlignedBB(0.75, 0.25, 0.25, 1.0, 0.75, 0.75);
    private static final AxisAlignedBB[] BOX_FACES = new AxisAlignedBB[]{BOX_DOWN, BOX_UP, BOX_NORTH, BOX_SOUTH, BOX_WEST, BOX_EAST};
    private static final ResourceLocation ADVANCEMENT_LOGIC_TRANSPORTATION = new ResourceLocation("buildcrafttransport:logic_transportation");

    public BlockPipeHolder(Material material, String id) {
        super(material, id);
        this.func_149711_c(0.25f);
        this.func_149752_b(3.0f);
        this.func_149713_g(0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{PROP_TILE});
    }

    @Override
    public TileBC_Neptune createTileEntity(World world, IBlockState state) {
        return new TilePipeHolder();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isPistonMoving) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null) {
            BlockPipeHolder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
            return;
        }
        boolean added = false;
        Pipe pipe = tile.getPipe();
        if (pipe != null) {
            BlockPipeHolder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOX_CENTER);
            added = true;
            for (Object face : EnumFacing.field_82609_l) {
                float conSize = pipe.getConnectedDist((EnumFacing)face);
                if (!(conSize > 0.0f)) continue;
                AxisAlignedBB aabb = BOX_FACES[face.ordinal()];
                if (conSize != 0.25f) {
                    Vec3d center = VecUtil.offset(new Vec3d(0.5, 0.5, 0.5), face, 0.25 + (double)(conSize / 2.0f));
                    Vec3d radius = new Vec3d(0.25, 0.25, 0.25);
                    radius = VecUtil.replaceValue(radius, face.func_176740_k(), conSize / 2.0f);
                    Vec3d min = center.func_178788_d(radius);
                    Vec3d max = center.func_178787_e(radius);
                    aabb = BoundingBoxUtil.makeFrom(min, max);
                }
                BlockPipeHolder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
            }
        }
        for (Object face : EnumFacing.field_82609_l) {
            PipePluggable pluggable = tile.getPluggable((EnumFacing)face);
            if (pluggable == null) continue;
            AxisAlignedBB bb = pluggable.getBoundingBox();
            BlockPipeHolder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb);
            added = true;
        }
        for (EnumWirePart part : tile.getWireManager().parts.keySet()) {
            BlockPipeHolder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)part.boundingBox);
            added = true;
        }
        for (EnumWireBetween between : tile.getWireManager().betweens.keySet()) {
            BlockPipeHolder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)between.boundingBox);
            added = true;
        }
        if (!added) {
            BlockPipeHolder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    @Nullable
    public RayTraceResult rayTrace(World world, BlockPos pos, EntityPlayer player) {
        Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        double reachDistance = 5.0;
        if (player instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3d end = start.func_178787_e(player.func_70040_Z().func_72432_b().func_186678_a(reachDistance));
        return this.rayTrace(world, pos, start, end);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        return this.rayTrace(world, pos, start, end);
    }

    @Nullable
    public RayTraceResult rayTrace(World world, BlockPos pos, Vec3d start, Vec3d end) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null) {
            return this.computeTrace(null, pos, start, end, field_185505_j, 400);
        }
        RayTraceResult best = null;
        Pipe pipe = tile.getPipe();
        boolean computed = false;
        if (pipe != null) {
            computed = true;
            best = this.computeTrace(best, pos, start, end, BOX_CENTER, 0);
            for (Object face : EnumFacing.field_82609_l) {
                float conSize = pipe.getConnectedDist((EnumFacing)face);
                if (!(conSize > 0.0f)) continue;
                AxisAlignedBB aabb = BOX_FACES[face.ordinal()];
                if (conSize != 0.25f) {
                    Vec3d center = VecUtil.offset(new Vec3d(0.5, 0.5, 0.5), face, 0.25 + (double)(conSize / 2.0f));
                    Vec3d radius = new Vec3d(0.25, 0.25, 0.25);
                    radius = VecUtil.replaceValue(radius, face.func_176740_k(), conSize / 2.0f);
                    Vec3d min = center.func_178788_d(radius);
                    Vec3d max = center.func_178787_e(radius);
                    aabb = BoundingBoxUtil.makeFrom(min, max);
                }
                best = this.computeTrace(best, pos, start, end, aabb, face.ordinal() + 1);
            }
        }
        for (Object face : EnumFacing.field_82609_l) {
            PipePluggable pluggable = tile.getPluggable((EnumFacing)face);
            if (pluggable == null) continue;
            AxisAlignedBB bb = pluggable.getBoundingBox();
            best = this.computeTrace(best, pos, start, end, bb, face.ordinal() + 1 + 6);
            computed = true;
        }
        for (EnumWirePart part : tile.getWireManager().parts.keySet()) {
            best = this.computeTrace(best, pos, start, end, part.boundingBox, part.ordinal() + 1 + 6 + 6);
            computed = true;
        }
        for (EnumWireBetween between : tile.getWireManager().betweens.keySet()) {
            best = this.computeTrace(best, pos, start, end, between.boundingBox, between.ordinal() + 1 + 6 + 6 + 8);
            computed = true;
        }
        if (!computed) {
            return this.computeTrace(null, pos, start, end, field_185505_j, 400);
        }
        return best;
    }

    @Nullable
    public static EnumWirePart rayTraceWire(BlockPos pos, Vec3d start, Vec3d end) {
        Vec3d realStart = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d realEnd = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        EnumWirePart best = null;
        double dist = 1000.0;
        for (EnumWirePart part : EnumWirePart.VALUES) {
            RayTraceResult trace = part.boundingBoxPossible.func_72327_a(realStart, realEnd);
            if (trace == null) continue;
            if (best == null) {
                best = part;
                dist = trace.field_72307_f.func_72436_e(realStart);
                continue;
            }
            double nextDist = trace.field_72307_f.func_72436_e(realStart);
            if (!(dist > nextDist)) continue;
            best = part;
            dist = nextDist;
        }
        return best;
    }

    private RayTraceResult computeTrace(RayTraceResult lastBest, BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB aabb, int part) {
        double distNext;
        RayTraceResult next = super.func_185503_a(pos, start, end, aabb);
        if (next == null) {
            return lastBest;
        }
        next.subHit = part;
        if (lastBest == null) {
            return next;
        }
        double distLast = lastBest.field_72307_f.func_72436_e(start);
        return distLast > (distNext = next.field_72307_f.func_72436_e(start)) ? next : lastBest;
    }

    @Nullable
    public static EnumFacing getPartSideHit(RayTraceResult trace) {
        if (trace.subHit <= 0) {
            return trace.field_178784_b;
        }
        if (trace.subHit <= 6) {
            return EnumFacing.field_82609_l[trace.subHit - 1];
        }
        if (trace.subHit <= 12) {
            return EnumFacing.field_82609_l[trace.subHit - 1 - 6];
        }
        return null;
    }

    @Nullable
    public static EnumWirePart getWirePartHit(RayTraceResult trace) {
        if (trace.subHit <= 12) {
            return null;
        }
        if (trace.subHit <= 20) {
            return EnumWirePart.VALUES[trace.subHit - 1 - 6 - 6];
        }
        return null;
    }

    @Nullable
    public static EnumWireBetween getWireBetweenHit(RayTraceResult trace) {
        if (trace.subHit <= 20) {
            return null;
        }
        if (trace.subHit <= 20 + EnumWireBetween.VALUES.length) {
            return EnumWireBetween.VALUES[trace.subHit - 1 - 6 - 6 - 8];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null) {
            return field_185505_j;
        }
        RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
        if (trace == null || trace.subHit < 0 || !pos.equals((Object)trace.func_178782_a())) {
            return field_185505_j;
        }
        int part = trace.subHit;
        AxisAlignedBB aabb = field_185505_j;
        if (part == 0) {
            aabb = BOX_CENTER;
        } else if (part < 7) {
            EnumFacing face;
            float conSize;
            aabb = BOX_FACES[part - 1];
            Pipe pipe = tile.getPipe();
            if (pipe != null && (conSize = pipe.getConnectedDist(face = EnumFacing.field_82609_l[part - 1])) > 0.0f && conSize != 0.25f) {
                Vec3d center = VecUtil.offset(new Vec3d(0.5, 0.5, 0.5), face, 0.25 + (double)(conSize / 2.0f));
                Vec3d radius = new Vec3d(0.25, 0.25, 0.25);
                radius = VecUtil.replaceValue(radius, face.func_176740_k(), conSize / 2.0f);
                Vec3d min = center.func_178788_d(radius);
                Vec3d max = center.func_178787_e(radius);
                aabb = BoundingBoxUtil.makeFrom(min, max);
            }
        } else if (part < 13) {
            EnumFacing side = EnumFacing.field_82609_l[part - 1 - 6];
            PipePluggable pluggable = tile.getPluggable(side);
            if (pluggable != null) {
                aabb = pluggable.getBoundingBox();
            }
        } else if (part < 21) {
            EnumWirePart wirePart = EnumWirePart.VALUES[part - 1 - 6 - 6];
            aabb = wirePart.boundingBox;
        } else if (part < 63) {
            EnumWireBetween wireBetween = EnumWireBetween.VALUES[part - 1 - 6 - 6 - 8];
            aabb = wireBetween.boundingBox;
        }
        if (part >= 13) {
            return aabb.func_186670_a(pos);
        }
        return (aabb == field_185505_j ? aabb : aabb.func_186662_g(0.03125)).func_186670_a(pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null || target == null) {
            return ItemStack.field_190927_a;
        }
        if (target.subHit <= 6) {
            PipeDefinition def;
            Item item;
            Pipe pipe = tile.getPipe();
            if (pipe != null && (item = (Item)PipeApi.pipeRegistry.getItemForPipe(def = pipe.getDefinition())) != null) {
                int meta = pipe.getColour() == null ? 0 : pipe.getColour().func_176765_a() + 1;
                return new ItemStack(item, 1, meta);
            }
        } else if (target.subHit <= 12) {
            int pluggableHit = target.subHit - 7;
            EnumFacing face = EnumFacing.field_82609_l[pluggableHit];
            PipePluggable plug = tile.getPluggable(face);
            if (plug != null) {
                return plug.getPickStack();
            }
        } else {
            EnumWirePart part = null;
            EnumWireBetween between = null;
            if (target.subHit > 6) {
                part = BlockPipeHolder.getWirePartHit(target);
                between = BlockPipeHolder.getWireBetweenHit(target);
            }
            if (part != null && tile.wireManager.getColorOfPart(part) != null) {
                return new ItemStack((Item)BCTransportItems.wire, 1, tile.wireManager.getColorOfPart(part).func_176765_a());
            }
            if (between != null && tile.wireManager.getColorOfPart(between.parts[0]) != null) {
                return new ItemStack((Item)BCTransportItems.wire, 1, tile.wireManager.getColorOfPart(between.parts[0]).func_176765_a());
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Pipe pipe;
        PipePluggable existing;
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null) {
            return false;
        }
        RayTraceResult trace = this.rayTrace(world, pos, player);
        if (trace == null) {
            return false;
        }
        EnumFacing realSide = BlockPipeHolder.getPartSideHit(trace);
        if (realSide == null) {
            realSide = side;
        }
        if (trace.subHit > 6 && trace.subHit <= 12 && (existing = tile.getPluggable(realSide)) != null) {
            return existing.onPluggableActivate(player, trace, hitX, hitY, hitZ);
        }
        EnumPipePart part = trace.subHit == 0 ? EnumPipePart.CENTER : EnumPipePart.fromFacing(realSide);
        ItemStack held = player.func_184586_b(hand);
        Item item = held.func_190926_b() ? null : held.func_77973_b();
        PipePluggable existing2 = tile.getPluggable(realSide);
        if (item instanceof IItemPluggable && existing2 == null) {
            IItemPluggable itemPlug = (IItemPluggable)item;
            PipePluggable plug = itemPlug.onPlace(held, tile, realSide, player, hand);
            if (plug == null) {
                return false;
            }
            tile.replacePluggable(realSide, plug);
            plug.onPlacedBy(player);
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            return true;
        }
        if (item instanceof ItemWire) {
            EnumWirePart wirePart;
            EnumWirePart wirePartHit = BlockPipeHolder.getWirePartHit(trace);
            TilePipeHolder attachTile = tile;
            if (wirePartHit != null) {
                WireNode node = new WireNode(pos, wirePartHit);
                node = node.offset(trace.field_178784_b);
                wirePart = node.part;
                if (!node.pos.equals((Object)pos)) {
                    attachTile = BlockPipeHolder.getPipe(world, node.pos, false);
                }
            } else {
                wirePart = EnumWirePart.get((trace.field_72307_f.field_72450_a % 1.0 + 1.0) % 1.0 > 0.5, (trace.field_72307_f.field_72448_b % 1.0 + 1.0) % 1.0 > 0.5, (trace.field_72307_f.field_72449_c % 1.0 + 1.0) % 1.0 > 0.5);
            }
            if (wirePart != null && attachTile != null) {
                EnumDyeColor colour = EnumDyeColor.func_176764_b((int)held.func_77960_j());
                boolean attached = attachTile.getWireManager().addPart(wirePart, colour);
                attachTile.scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.WIRES);
                if (attached) {
                    WireNode from = new WireNode(attachTile.getPipePos(), wirePart);
                    boolean isNowConnected = false;
                    for (EnumFacing dir : EnumFacing.values()) {
                        WireNode to = from.offset(dir);
                        if (to.pos == attachTile.getPipePos()) {
                            if (attachTile.getWireManager().getColorOfPart(to.part) != colour) continue;
                            isNowConnected = true;
                            break;
                        }
                        TileEntity localTile = attachTile.getLocalTile(to.pos);
                        if (!(localTile instanceof TilePipeHolder) || ((TilePipeHolder)localTile).getWireManager().getColorOfPart(to.part) != colour) continue;
                        isNowConnected = true;
                        break;
                    }
                    if (isNowConnected) {
                        AdvancementUtil.unlockAdvancement(player, ADVANCEMENT_LOGIC_TRANSPORTATION);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        held.func_190918_g(1);
                    }
                }
                if (attached) {
                    return true;
                }
            }
        }
        if ((pipe = tile.getPipe()) == null) {
            return false;
        }
        if (pipe.behaviour.onPipeActivate(player, trace, hitX, hitY, hitZ, part)) {
            return true;
        }
        return pipe.flow.onFlowActivate(player, trace, hitX, hitY, hitZ, part);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return false;
        }
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        NonNullList toDrop = NonNullList.func_191196_a();
        RayTraceResult trace = this.rayTrace(world, pos, player);
        EnumFacing side = null;
        EnumWirePart part = null;
        EnumWireBetween between = null;
        if (trace != null && trace.subHit > 6) {
            side = BlockPipeHolder.getPartSideHit(trace);
            part = BlockPipeHolder.getWirePartHit(trace);
            between = BlockPipeHolder.getWireBetweenHit(trace);
        }
        if (side != null) {
            BlockPipeHolder.removePluggable(side, tile, (NonNullList<ItemStack>)toDrop);
            if (!player.field_71075_bZ.field_75098_d) {
                InventoryUtil.dropAll(world, pos, (NonNullList<ItemStack>)toDrop);
            }
            return false;
        }
        if (part != null) {
            toDrop.add((Object)new ItemStack((Item)BCTransportItems.wire, 1, tile.wireManager.getColorOfPart(part).func_176765_a()));
            tile.wireManager.removePart(part);
            if (!player.field_71075_bZ.field_75098_d) {
                InventoryUtil.dropAll(world, pos, (NonNullList<ItemStack>)toDrop);
            }
            tile.scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.WIRES);
            return false;
        }
        if (between != null) {
            toDrop.add((Object)new ItemStack((Item)BCTransportItems.wire, between.to == null ? 2 : 1, tile.wireManager.getColorOfPart(between.parts[0]).func_176765_a()));
            if (between.to == null) {
                tile.wireManager.removeParts(Arrays.asList(between.parts));
            } else {
                tile.wireManager.removePart(between.parts[0]);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                InventoryUtil.dropAll(world, pos, (NonNullList<ItemStack>)toDrop);
            }
            tile.scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.WIRES);
            return false;
        }
        toDrop.addAll((Collection)this.getDrops((IBlockAccess)world, pos, state, 0));
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPipeHolder.removePluggable(face, tile, (NonNullList<ItemStack>)NonNullList.func_191196_a());
        }
        if (!player.field_71075_bZ.field_75098_d) {
            InventoryUtil.dropAll(world, pos, (NonNullList<ItemStack>)toDrop);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    public void getDrops(NonNullList<ItemStack> toDrop, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            PipePluggable pluggable = tile.getPluggable(face);
            if (pluggable == null) continue;
            pluggable.addDrops(toDrop, fortune);
        }
        for (EnumDyeColor color : tile.wireManager.parts.values()) {
            toDrop.add((Object)new ItemStack((Item)BCTransportItems.wire, 1, color.func_176765_a()));
        }
        Pipe pipe = tile.getPipe();
        if (pipe != null) {
            pipe.addDrops(toDrop, fortune);
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (exploder != null) {
            float explosionResistance;
            PipePluggable pluggable;
            Vec3d subtract = exploder.func_174791_d().func_178788_d(new Vec3d((Vec3i)pos).func_178787_e(VecUtil.VEC_HALF)).func_72432_b();
            EnumFacing side = Arrays.stream(EnumFacing.field_82609_l).min(Comparator.comparing(facing -> new Vec3d(facing.func_176730_m()).func_72438_d(subtract))).orElseThrow(IllegalArgumentException::new);
            TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, true);
            if (tile != null && (pluggable = tile.getPluggable(side)) != null && (explosionResistance = pluggable.getExplosionResistance(exploder, explosion)) > 0.0f) {
                return explosionResistance;
            }
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null) {
            return;
        }
        Pipe pipe = tile.getPipe();
        if (pipe != null) {
            pipe.getBehaviour().onEntityCollide(entity);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null) {
            return false;
        }
        PipePluggable pluggable = tile.getPluggable(facing);
        return pluggable != null && pluggable.canBeConnected();
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null) {
            return false;
        }
        PipePluggable pluggable = tile.getPluggable(side);
        return pluggable != null && pluggable.isSideSolid();
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile == null) {
            return BlockFaceShape.UNDEFINED;
        }
        PipePluggable pluggable = tile.getPluggable(face);
        return pluggable != null ? pluggable.getBlockFaceShape() : BlockFaceShape.UNDEFINED;
    }

    private static void removePluggable(EnumFacing side, TilePipeHolder tile, NonNullList<ItemStack> toDrop) {
        PipePluggable removed = tile.replacePluggable(side, null);
        if (removed != null) {
            removed.onRemove();
            removed.addDrops(toDrop, 0);
        }
    }

    public static TilePipeHolder getPipe(IBlockAccess access, BlockPos pos, boolean requireServer) {
        if (access instanceof World) {
            return BlockPipeHolder.getPipe((World)access, pos, requireServer);
        }
        if (requireServer) {
            return null;
        }
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TilePipeHolder) {
            return (TilePipeHolder)tile;
        }
        return null;
    }

    public static TilePipeHolder getPipe(World world, BlockPos pos, boolean requireServer) {
        if (requireServer && world.field_72995_K) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePipeHolder) {
            return (TilePipeHolder)tile;
        }
        return null;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return super.addLandingEffects(state, worldObj, blockPosition, iblockstate, entity, numberOfParticles);
    }

    private static HitSpriteInfo getHitSpriteInfo(RayTraceResult target, TilePipeHolder pipeHolder) {
        int p = target.subHit;
        AxisAlignedBB aabb = null;
        TextureAtlasSprite sprite = SpriteUtil.missingSprite();
        if (0 <= p && p <= 6) {
            aabb = p == 0 ? BOX_CENTER : BOX_FACES[p - 1];
            PipeDefinition def = pipeHolder.getPipe().definition;
            TextureAtlasSprite[] sprites = PipeModelCacheBase.generator.getItemSprites(def);
            sprite = sprites.length == 0 ? SpriteUtil.missingSprite() : sprites[0];
        } else if (7 <= p && p < 13) {
            PipePluggable plug = pipeHolder.getPluggable(EnumFacing.values()[p - 6 - 1]);
            if (plug == null) {
                return null;
            }
            aabb = plug.getBoundingBox();
            if (aabb == null) {
                return null;
            }
            PluggableModelKey keyC = plug.getModelRenderKey(BlockRenderLayer.CUTOUT);
            PluggableModelKey keyT = plug.getModelRenderKey(BlockRenderLayer.TRANSLUCENT);
            if (keyC == null && keyT == null) {
                return null;
            }
            List<BakedQuad> quads = null;
            if (keyC != null) {
                quads = PipeModelCachePluggable.cacheCutoutSingle.bake(keyC);
            }
            if (quads == null || quads.isEmpty()) {
                if (keyT == null) {
                    return null;
                }
                quads = PipeModelCachePluggable.cacheTranslucentSingle.bake(keyT);
                if (quads == null || quads.isEmpty()) {
                    return null;
                }
            }
            sprite = quads.get(0).func_187508_a();
        } else if (13 <= p && p < 21) {
            EnumWirePart wirePart = EnumWirePart.values()[p - 6 - 6 - 1];
            aabb = wirePart.boundingBox;
            EnumDyeColor colour = pipeHolder.getWireManager().getColorOfPart(wirePart);
            if (colour == null) {
                return null;
            }
            sprite = PipeWireRenderer.getWireSprite(colour).getSprite();
        } else if (21 < p && p <= 57) {
            EnumWireBetween wireBetween = EnumWireBetween.values()[p - 6 - 6 - 1 - 8];
            aabb = wireBetween.boundingBox;
            EnumDyeColor colour = pipeHolder.getWireManager().betweens.get((Object)wireBetween);
            if (colour == null) {
                return null;
            }
            sprite = PipeWireRenderer.getWireSprite(colour).getSprite();
        } else {
            return null;
        }
        if (aabb == null) {
            throw new IllegalStateException("Null aabb for index " + p + " (and sprite " + sprite + ")");
        }
        return new HitSpriteInfo(aabb, sprite);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        TileEntity te = world.func_175625_s(target.func_178782_a());
        if (te instanceof TilePipeHolder) {
            TilePipeHolder pipeHolder = (TilePipeHolder)te;
            HitSpriteInfo info = BlockPipeHolder.getHitSpriteInfo(target, pipeHolder);
            if (info == null) {
                return false;
            }
            double x = Math.random() * (info.aabb.field_72336_d - info.aabb.field_72340_a) + info.aabb.field_72340_a;
            double y = Math.random() * (info.aabb.field_72337_e - info.aabb.field_72338_b) + info.aabb.field_72338_b;
            double z = Math.random() * (info.aabb.field_72334_f - info.aabb.field_72339_c) + info.aabb.field_72339_c;
            switch (target.field_178784_b) {
                case DOWN: {
                    y = info.aabb.field_72338_b - 0.1;
                    break;
                }
                case UP: {
                    y = info.aabb.field_72337_e + 0.1;
                    break;
                }
                case NORTH: {
                    z = info.aabb.field_72339_c - 0.1;
                    break;
                }
                case SOUTH: {
                    z = info.aabb.field_72334_f + 0.1;
                    break;
                }
                case WEST: {
                    x = info.aabb.field_72340_a - 0.1;
                    break;
                }
                default: {
                    x = info.aabb.field_72336_d + 0.1;
                }
            }
            ParticleDigging particle = new ParticleDigging(world, x += (double)target.func_178782_a().func_177958_n(), y += (double)target.func_178782_a().func_177956_o(), z += (double)target.func_178782_a().func_177952_p(), 0.0, 0.0, 0.0, state){};
            particle.func_174846_a(target.func_178782_a());
            particle.func_187117_a(info.sprite);
            particle.func_70543_e(0.2f);
            particle.func_70541_f(0.6f);
            manager.func_78873_a((Particle)particle);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        RayTraceResult hitResult = Minecraft.func_71410_x().field_71476_x;
        if (hitResult == null || !pos.equals((Object)hitResult.func_178782_a())) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePipeHolder) {
            TilePipeHolder pipeHolder = (TilePipeHolder)te;
            HitSpriteInfo info = BlockPipeHolder.getHitSpriteInfo(hitResult, pipeHolder);
            if (info == null) {
                return false;
            }
            double sizeX = info.aabb.field_72336_d - info.aabb.field_72340_a;
            double sizeY = info.aabb.field_72337_e - info.aabb.field_72338_b;
            double sizeZ = info.aabb.field_72334_f - info.aabb.field_72339_c;
            int countX = (int)Math.max(2.0, 4.0 * sizeX);
            int countY = (int)Math.max(2.0, 4.0 * sizeY);
            int countZ = (int)Math.max(2.0, 4.0 * sizeZ);
            IBlockState state = world.func_180495_p(pos);
            for (int x = 0; x < countX; ++x) {
                for (int y = 0; y < countY; ++y) {
                    for (int z = 0; z < countZ; ++z) {
                        double _x = (double)pos.func_177958_n() + info.aabb.field_72340_a + ((double)x + 0.5) * sizeX / (double)countX;
                        double _y = (double)pos.func_177956_o() + info.aabb.field_72338_b + ((double)y + 0.5) * sizeY / (double)countY;
                        double _z = (double)pos.func_177952_p() + info.aabb.field_72339_c + ((double)z + 0.5) * sizeZ / (double)countZ;
                        ParticleDigging particle = new ParticleDigging(world, _x, _y, _z, 0.0, 0.0, 0.0, state){};
                        particle.func_174846_a(pos);
                        particle.func_187117_a(info.sprite);
                        manager.func_78873_a((Particle)particle);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumActionResult attemptPaint(World world, BlockPos pos, IBlockState state, Vec3d hitPos, EnumFacing hitSide, EnumDyeColor paintColour) {
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, true);
        if (tile == null) {
            return EnumActionResult.PASS;
        }
        Pipe pipe = tile.getPipe();
        if (pipe == null) {
            return EnumActionResult.FAIL;
        }
        if (pipe.getColour() == paintColour || !pipe.definition.canBeColoured) {
            return EnumActionResult.FAIL;
        }
        pipe.setColour(paintColour);
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extended = (IExtendedBlockState)state;
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile != null) {
            extended = extended.withProperty(PROP_TILE, new WeakReference<TilePipeHolder>(tile));
        }
        return extended;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        if (side == null) {
            return false;
        }
        TilePipeHolder tile = BlockPipeHolder.getPipe(world, pos, false);
        if (tile != null) {
            PipePluggable pluggable = tile.getPluggable(side.func_176734_d());
            return pluggable != null && pluggable.canConnectToRedstone(side);
        }
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        TilePipeHolder tile = BlockPipeHolder.getPipe(blockAccess, pos, false);
        if (tile != null) {
            return tile.getRedstoneOutput(side.func_176734_d());
        }
        return 0;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_176211_b(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    private static final class HitSpriteInfo {
        final AxisAlignedBB aabb;
        final TextureAtlasSprite sprite;

        HitSpriteInfo(AxisAlignedBB aabb, TextureAtlasSprite sprite) {
            this.aabb = aabb;
            this.sprite = sprite;
        }
    }
}

