/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.facades.FacadeAPI;
import buildcraft.lib.registry.CreativeTabManager;
import buildcraft.lib.registry.RegistryConfig;
import buildcraft.lib.registry.TagManager;
import buildcraft.silicon.BCSiliconBlocks;
import buildcraft.silicon.BCSiliconConfig;
import buildcraft.silicon.BCSiliconItems;
import buildcraft.silicon.BCSiliconPlugs;
import buildcraft.silicon.BCSiliconProxy;
import buildcraft.silicon.BCSiliconStatements;
import buildcraft.silicon.plug.FacadeBlockStateInfo;
import buildcraft.silicon.plug.FacadeInstance;
import buildcraft.silicon.plug.FacadeStateManager;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="buildcraftsilicon", name="BuildCraft Silicon", version="7.99.24.3", dependencies="required-after:buildcraftcore@[7.99.24.3];after:buildcrafttransport", acceptedMinecraftVersions="[1.12.2]")
public class BCSilicon {
    public static final String MODID = "buildcraftsilicon";
    @Mod.Instance(value="buildcraftsilicon")
    public static BCSilicon INSTANCE = null;
    private static CreativeTabManager.CreativeTabBC tabFacades;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent evt) {
        RegistryConfig.useOtherModConfigFor(MODID, "buildcraftcore");
        tabFacades = CreativeTabManager.createTab("buildcraft.facades");
        FacadeAPI.registry = FacadeStateManager.INSTANCE;
        BCSiliconConfig.preInit();
        BCSiliconBlocks.preInit();
        BCSiliconPlugs.preInit();
        BCSiliconItems.preInit();
        BCSiliconStatements.preInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)BCSiliconProxy.getProxy());
        BCSiliconProxy.getProxy().fmlPreInit();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent evt) {
        BCSiliconProxy.getProxy().fmlInit();
        FacadeStateManager.init();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent evt) {
        BCSiliconProxy.getProxy().fmlPostInit();
        if (BCSiliconItems.plugFacade != null) {
            FacadeBlockStateInfo state = FacadeStateManager.previewState;
            FacadeInstance inst = FacadeInstance.createSingle(state, false);
            tabFacades.setItem(BCSiliconItems.plugFacade.createItemStack(inst));
        }
    }

    @Mod.EventHandler
    public static void onImcEvent(FMLInterModComms.IMCEvent imc) {
        for (FMLInterModComms.IMCMessage message : imc.getMessages()) {
            FacadeStateManager.receiveInterModComms(message);
        }
    }

    private static TagManager.TagEntry registerTag(String id) {
        return TagManager.registerTag(id);
    }

    private static void startBatch() {
        TagManager.startBatch();
    }

    private static void endBatch(Consumer<TagManager.TagEntry> consumer) {
        TagManager.endBatch(consumer);
    }

    static {
        BCSilicon.startBatch();
        BCSilicon.registerTag("item.redstone_chipset").reg("redstone_chipset").locale("redstone_chipset").model("redstone_chipset/");
        BCSilicon.registerTag("item.plug.gate").reg("plug_gate").locale("gate").model("pluggable/gate").tab("buildcraft.plugs").oldReg("plug_gate");
        BCSilicon.registerTag("item.plug.lens").reg("plug_lens").locale("lens").model("pluggable/lens").tab("buildcraft.plugs").oldReg("plug_lens");
        BCSilicon.registerTag("item.plug.pulsar").reg("plug_pulsar").locale("pulsar").model("plug_pulsar").tab("buildcraft.plugs").oldReg("plug_pulsar");
        BCSilicon.registerTag("item.plug.light_sensor").reg("plug_light_sensor").locale("light_sensor").model("plug_light_sensor").tab("buildcraft.plugs").oldReg("plug_light_sensor");
        BCSilicon.registerTag("item.plug.facade").reg("plug_facade").locale("Facade").model("plug_facade").tab("buildcraft.facades").oldReg("plug_facade");
        BCSilicon.registerTag("item.block.laser").reg("laser").locale("laserBlock").model("laser");
        BCSilicon.registerTag("item.block.assembly_table").reg("assembly_table").locale("assemblyTableBlock").model("assembly_table");
        BCSilicon.registerTag("item.block.advanced_crafting_table").reg("advanced_crafting_table").locale("assemblyWorkbenchBlock").model("advanced_crafting_table");
        BCSilicon.registerTag("item.block.integration_table").reg("integration_table").locale("integrationTableBlock").model("integration_table");
        BCSilicon.registerTag("item.block.charging_table").reg("charging_table").locale("chargingTableBlock").model("charging_table");
        BCSilicon.registerTag("item.block.programming_table").reg("programming_table").locale("programmingTableBlock").model("programming_table");
        BCSilicon.registerTag("block.laser").reg("laser").oldReg("laserBlock").locale("laserBlock").model("laser");
        BCSilicon.registerTag("block.assembly_table").reg("assembly_table").oldReg("assemblyTableBlock").locale("assemblyTableBlock").model("assembly_table");
        BCSilicon.registerTag("block.advanced_crafting_table").reg("advanced_crafting_table").oldReg("advancedCraftingTableBlock").locale("assemblyWorkbenchBlock").model("advanced_crafting_table");
        BCSilicon.registerTag("block.integration_table").reg("integration_table").oldReg("integrationTableBlock").locale("integrationTableBlock").model("integration_table");
        BCSilicon.registerTag("block.charging_table").reg("charging_table").oldReg("chargingTableBlock").locale("chargingTableBlock").model("charging_table");
        BCSilicon.registerTag("block.programming_table").reg("programming_table").oldReg("programmingTableBlock").locale("programmingTableBlock").model("programming_table");
        BCSilicon.registerTag("tile.laser").reg("laser");
        BCSilicon.registerTag("tile.assembly_table").reg("assembly_table");
        BCSilicon.registerTag("tile.advanced_crafting_table").reg("advanced_crafting_table");
        BCSilicon.registerTag("tile.integration_table").reg("integration_table");
        BCSilicon.registerTag("tile.charging_table").reg("charging_table");
        BCSilicon.registerTag("tile.programming_table").reg("programming_table");
        BCSilicon.endBatch(TagManager.prependTags("buildcraftsilicon:", TagManager.EnumTagType.REGISTRY_NAME, TagManager.EnumTagType.MODEL_LOCATION).andThen(TagManager.setTab("buildcraft.main")));
    }
}

