/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.laser;

import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.render.laser.ILaserRenderer;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LaserContext {
    public final Matrix4f matrix = new Matrix4f();
    private final Point3f point = new Point3f();
    private final Vector4f normal = new Vector4f();
    private final ILaserRenderer renderer;
    public final double length;
    private final boolean useNormalColour;
    private final boolean drawBothSides;
    private final int minBlockLight;
    private int index = 0;
    private final double[] x = new double[]{0.0, 0.0, 0.0, 0.0};
    private final double[] y = new double[]{0.0, 0.0, 0.0, 0.0};
    private final double[] z = new double[]{0.0, 0.0, 0.0, 0.0};
    private final double[] u = new double[]{0.0, 0.0, 0.0, 0.0};
    private final double[] v = new double[]{0.0, 0.0, 0.0, 0.0};
    private final int[] l = new int[]{0, 0, 0, 0};
    private final float[] n = new float[]{0.0f, 1.0f, 0.0f};
    private float diffuse;

    public LaserContext(ILaserRenderer renderer, LaserData_BC8 data, boolean useNormalColour, boolean isCullEnabled) {
        double angleY;
        this.renderer = renderer;
        this.useNormalColour = useNormalColour;
        this.drawBothSides = isCullEnabled;
        this.minBlockLight = data.minBlockLight;
        Vec3d delta = data.start.func_178788_d(data.end);
        double dx = delta.field_72450_a;
        double dy = delta.field_72448_b;
        double dz = delta.field_72449_c;
        double realLength = delta.func_72433_c();
        this.length = realLength / data.scale;
        double angleZ = Math.PI - Math.atan2(dz, dx);
        double rl_squared = realLength * realLength;
        double dy_dy = dy * dy;
        if (dx == 0.0 && dz == 0.0) {
            double angle = 1.5707963267948966;
            angleY = dy < 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            dx = Math.sqrt(rl_squared - dy_dy);
            angleY = -Math.atan2(dy, dx);
        }
        this.matrix.setIdentity();
        Matrix4f holding = new Matrix4f();
        holding.setIdentity();
        Vector3f translation = new Vector3f();
        translation.x = (float)data.start.field_72450_a;
        translation.y = (float)data.start.field_72448_b;
        translation.z = (float)data.start.field_72449_c;
        holding.setTranslation(translation);
        this.matrix.mul(holding);
        holding.setIdentity();
        holding.m00 = (float)data.scale;
        holding.m11 = (float)data.scale;
        holding.m22 = (float)data.scale;
        this.matrix.mul(holding);
        holding.setIdentity();
        holding.rotY((float)angleZ);
        this.matrix.mul(holding);
        holding.setIdentity();
        holding.rotZ((float)angleY);
        this.matrix.mul(holding);
        holding.setIdentity();
    }

    @SideOnly(value=Side.CLIENT)
    public void setFaceNormal(double nx, double ny, double nz) {
        if (this.useNormalColour) {
            this.normal.x = (float)nx;
            this.normal.y = (float)ny;
            this.normal.z = (float)nz;
            this.normal.w = 0.0f;
            this.matrix.transform((Tuple4f)this.normal);
            this.n[0] = this.normal.x;
            this.n[1] = this.normal.y;
            this.n[2] = this.normal.z;
            this.diffuse = MutableQuad.diffuseLight(this.n[0], this.n[1], this.n[2]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addPoint(double xIn, double yIn, double zIn, double uIn, double vIn) {
        this.point.x = (float)xIn;
        this.point.y = (float)yIn;
        this.point.z = (float)zIn;
        this.matrix.transform(this.point);
        int lmap = LaserRenderer_BC8.computeLightmap(this.point.x, this.point.y, this.point.z, this.minBlockLight);
        this.x[this.index] = this.point.x;
        this.y[this.index] = this.point.y;
        this.z[this.index] = this.point.z;
        this.u[this.index] = uIn;
        this.v[this.index] = vIn;
        this.l[this.index] = lmap;
        ++this.index;
        if (this.index == 4) {
            this.index = 0;
            this.vertex(0);
            this.vertex(1);
            this.vertex(2);
            this.vertex(3);
            if (this.drawBothSides) {
                this.n[0] = -this.n[0];
                this.n[1] = -this.n[1];
                this.n[2] = -this.n[2];
                this.diffuse = MutableQuad.diffuseLight(this.n[0], this.n[1], this.n[2]);
                this.vertex(3);
                this.vertex(2);
                this.vertex(1);
                this.vertex(0);
            }
            this.n[0] = 0.0f;
            this.n[1] = 1.0f;
            this.n[2] = 0.0f;
        }
    }

    private void vertex(int i) {
        if (this.useNormalColour) {
            this.renderer.vertex(this.x[i], this.y[i], this.z[i], this.u[i], this.v[i], this.l[i], this.n[0], this.n[1], this.n[2], this.diffuse);
        } else {
            this.renderer.vertex(this.x[i], this.y[i], this.z[i], this.u[i], this.v[i], this.l[i], 0.0f, 1.0f, 0.0f, 1.0f);
        }
    }
}

