/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern;

import buildcraft.api.filler.IFilledTemplate;
import buildcraft.api.filler.IFillerPatternShape;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.builders.snapshot.pattern.Pattern;
import buildcraft.builders.snapshot.pattern.parameter.PatternParameterAxis;
import buildcraft.builders.snapshot.pattern.parameter.PatternParameterHollow;
import buildcraft.builders.snapshot.pattern.parameter.PatternParameterRotation;
import buildcraft.lib.misc.PositionUtil;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class PatternShape2d
extends Pattern
implements IFillerPatternShape {
    public PatternShape2d(String tag) {
        super(tag);
    }

    @Override
    public int minParameters() {
        return 3;
    }

    @Override
    public int maxParameters() {
        return 3;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        switch (index) {
            case 0: {
                return PatternParameterAxis.Y;
            }
            case 1: {
                return PatternParameterHollow.HOLLOW;
            }
            case 2: {
                return PatternParameterRotation.NONE;
            }
        }
        return null;
    }

    @Override
    public boolean fillTemplate(IFilledTemplate filledTemplate, IStatementParameter[] params) {
        PatternParameterAxis axis = PatternShape2d.getParam(0, params, PatternParameterAxis.Y);
        PatternParameterRotation dir = PatternShape2d.getParam(2, params, PatternParameterRotation.NONE);
        PositionUtil.PathIterator2d iterator = PatternShape2d.getIterator(filledTemplate, axis);
        int maxA = axis == PatternParameterAxis.X ? filledTemplate.getMax().func_177956_o() : filledTemplate.getMax().func_177958_n();
        int maxB = axis == PatternParameterAxis.Z ? filledTemplate.getMax().func_177956_o() : filledTemplate.getMax().func_177952_p();
        int normMaxA = maxA;
        int normMaxB = maxB;
        if (dir.rotationCount % 2 == 1) {
            int maxT = maxA;
            maxA = maxB;
            int max_b = maxB = maxT;
            PositionUtil.PathIterator2d old = iterator;
            iterator = (a, b) -> old.iterate(max_b - b, a);
        }
        if (dir.rotationCount > 1) {
            PositionUtil.PathIterator2d old = iterator;
            int max_a = maxA;
            int max_b = maxB;
            iterator = (a, b) -> old.iterate(max_a - a, max_b - b);
        }
        LineList list = new LineList(iterator);
        this.genShape(maxA, maxB, list);
        PatternParameterHollow filled = PatternShape2d.getParam(1, params, PatternParameterHollow.HOLLOW);
        if (filled.filled) {
            int fillA = list.fillInA;
            int fillB = list.fillInB;
            if (fillA != -1 && fillB != -1) {
                maxA = normMaxA;
                maxB = normMaxB;
                if (dir.rotationCount % 2 == 1) {
                    int fillT = fillA;
                    fillA = fillB;
                    fillB = fillT;
                }
                if (dir.rotationCount > 1) {
                    fillA = maxA - fillA;
                    fillB = maxB - fillB;
                }
                iterator = PatternShape2d.getIterator(filledTemplate, axis);
                PositionGetter getter = PatternShape2d.getFillGetter(filledTemplate, axis);
                if (filled.outerFilled) {
                    iterator = (a, b) -> {};
                }
                HashSet<Point> visited = new HashSet<Point>();
                ArrayList<Point> open = new ArrayList<Point>();
                open.add(new Point(fillA, fillB));
                while (!open.isEmpty()) {
                    ArrayList<Point> next = new ArrayList<Point>();
                    for (Point p : open) {
                        if (p.a < 0 || p.a > maxA || p.b < 0 || p.b > maxB || !visited.add(p) || getter.isFilled(p.a, p.b)) continue;
                        iterator.iterate(p.a, p.b);
                        next.add(new Point(p.a + 1, p.b));
                        next.add(new Point(p.a - 1, p.b));
                        next.add(new Point(p.a, p.b + 1));
                        next.add(new Point(p.a, p.b - 1));
                    }
                    open = next;
                }
                if (filled.outerFilled) {
                    iterator = PatternShape2d.getIterator(filledTemplate, axis);
                    for (int a2 = 0; a2 <= maxA; ++a2) {
                        for (int b2 = 0; b2 <= maxB; ++b2) {
                            if (visited.contains(new Point(a2, b2))) continue;
                            iterator.iterate(a2, b2);
                        }
                    }
                }
            }
        }
        return true;
    }

    private static PositionUtil.PathIterator2d getIterator(IFilledTemplate filledTemplate, PatternParameterAxis axis) {
        switch (axis) {
            case X: {
                return (y, z) -> filledTemplate.setLineX(0, filledTemplate.getMax().func_177958_n(), y, z, true);
            }
            case Y: {
                return (x, z) -> filledTemplate.setLineY(x, 0, filledTemplate.getMax().func_177956_o(), z, true);
            }
            case Z: {
                return (x, y) -> filledTemplate.setLineZ(x, y, 0, filledTemplate.getMax().func_177952_p(), true);
            }
        }
        throw new IllegalArgumentException("Unknown axis " + axis);
    }

    private static PositionGetter getFillGetter(IFilledTemplate filledTemplate, PatternParameterAxis axis) {
        switch (axis) {
            case X: {
                return (a, b) -> filledTemplate.get(0, a, b);
            }
            case Y: {
                return (a, b) -> filledTemplate.get(a, 0, b);
            }
            case Z: {
                return (a, b) -> filledTemplate.get(a, b, 0);
            }
        }
        throw new IllegalArgumentException("Unknown axis " + axis);
    }

    protected abstract void genShape(int var1, int var2, LineList var3);

    public static enum ArcType {
        ARC(false, false),
        SEMI_CIRCLE(true, false),
        FULL_CIRCLE(true, true);

        final boolean second;
        final boolean all;

        private ArcType(boolean second, boolean all) {
            this.second = second;
            this.all = all;
        }

        public boolean shouldDrawSecondQuadrant() {
            return this.second;
        }

        public boolean shouldDrawAllQuadrants() {
            return this.all;
        }
    }

    public static class LineList {
        private PositionUtil.PathIterator2d iterator;
        private int lastA;
        private int lastB;
        private int fillInA = -1;
        private int fillInB = -1;

        public LineList(PositionUtil.PathIterator2d iterator) {
            this.iterator = iterator;
        }

        public void setFillPoint(int a, int b) {
            this.fillInA = a;
            this.fillInB = b;
        }

        public void moveTo(int a, int b) {
            this.lastA = a;
            this.lastB = b;
        }

        public void lineTo(int a, int b) {
            PositionUtil.forAllOnPath2d(this.lastA, this.lastB, a, b, this.iterator);
            this.moveTo(a, b);
        }

        public void lineFrom(int a, int b) {
            int a2 = this.lastA;
            int b2 = this.lastB;
            this.moveTo(a, b);
            this.lineTo(a2, b2);
            this.moveTo(a, b);
        }

        public void arc(int ca, int cb, double ra, double rb) {
            this.arc(ca, cb, ra, rb, 0, 0, ArcType.ARC);
        }

        public void arc(int ca, int cb, double ra, double rb, int da, int db, ArcType type) {
            if (ra <= 0.0) {
                throw new IllegalArgumentException("'ra' was less than or equal to 0! (Was " + ra + ")");
            }
            if (rb <= 0.0) {
                throw new IllegalArgumentException("'rb' was less than or equal to 0! (Was " + rb + ")");
            }
            double ra2 = ra * ra;
            double rb2 = rb * rb;
            double sigma = 2.0 * rb2 + ra2 * (1.0 - 2.0 * rb);
            int a = 0;
            int b = (int)rb;
            while (rb2 * (double)a <= ra2 * (double)b) {
                this.iterator.iterate(ca - a, cb - b);
                if (type.shouldDrawSecondQuadrant()) {
                    this.iterator.iterate(ca + a + da, cb - b);
                    if (type.shouldDrawAllQuadrants()) {
                        this.iterator.iterate(ca - a, cb + b + db);
                        this.iterator.iterate(ca + a + da, cb + b + db);
                    }
                }
                if (sigma >= 0.0) {
                    sigma += 4.0 * ra2 * (double)(1 - b);
                    --b;
                }
                sigma += rb2 * (double)(4 * a + 6);
                ++a;
            }
            sigma = 2.0 * ra2 + rb2 * (1.0 - 2.0 * ra);
            a = (int)ra;
            b = 0;
            while (ra2 * (double)b <= rb2 * (double)a) {
                this.iterator.iterate(ca - a, cb - b);
                if (type.shouldDrawSecondQuadrant()) {
                    this.iterator.iterate(ca + a + da, cb - b);
                    if (type.shouldDrawAllQuadrants()) {
                        this.iterator.iterate(ca - a, cb + b + db);
                        this.iterator.iterate(ca + a + da, cb + b + db);
                    }
                }
                if (sigma >= 0.0) {
                    sigma += 4.0 * rb2 * (double)(1 - a);
                    --a;
                }
                sigma += ra2 * (double)(4 * b + 6);
                ++b;
            }
        }
    }

    static class Point {
        final int a;
        final int b;

        Point(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.a;
            result = 31 * result + this.b;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Point other = (Point)obj;
            if (this.a != other.a) {
                return false;
            }
            return this.b == other.b;
        }
    }

    @FunctionalInterface
    static interface PositionGetter {
        public boolean isFilled(int var1, int var2);
    }
}

