/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.network.IClientServerDelayed;
import mcjty.lib.network.PacketDataFromServer;
import mcjty.lib.network.PacketDumpBlockInfo;
import mcjty.lib.network.PacketDumpItemInfo;
import mcjty.lib.network.PacketFinalizeLogin;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.network.PacketSendClientCommand;
import mcjty.lib.network.PacketSendGuiData;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.thirteen.SimpleChannel;
import mcjty.lib.typed.TypedMap;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class PacketHandler {
    public static final int INTERNAL_PACKETS = 12;
    public static boolean connected = false;
    private static int packetId = 12;
    public static Map<String, SimpleNetworkWrapper> modNetworking = new HashMap<String, SimpleNetworkWrapper>();

    public static int nextPacketID() {
        return packetId++;
    }

    public static SimpleNetworkWrapper registerMessages(String modid, String channelName) {
        SimpleNetworkWrapper network = new SimpleNetworkWrapper(channelName){

            public void sendToServer(IMessage message) {
                if (message instanceof IClientServerDelayed && !PacketHandler.canBeSent(message)) {
                    return;
                }
                super.sendToServer(message);
            }
        };
        PacketHandler.registerMessages(network);
        modNetworking.put(modid, network);
        return network;
    }

    private static boolean canBeSent(IMessage message) {
        return connected;
    }

    public static void onDisconnect() {
        connected = false;
    }

    private static void registerMessages(SimpleNetworkWrapper networkWrapper) {
        int startIndex = 0;
        SimpleChannel channel = new SimpleChannel(networkWrapper);
        channel.registerMessageServer(startIndex++, PacketServerCommandTyped.class, PacketServerCommandTyped::toBytes, PacketServerCommandTyped::new, PacketServerCommandTyped::handle);
        channel.registerMessageServer(startIndex++, PacketSendServerCommand.class, PacketSendServerCommand::toBytes, PacketSendServerCommand::new, PacketSendServerCommand::handle);
        channel.registerMessageServer(startIndex++, PacketRequestDataFromServer.class, PacketRequestDataFromServer::toBytes, PacketRequestDataFromServer::new, PacketRequestDataFromServer::handle);
        channel.registerMessageServer(startIndex++, PacketDumpItemInfo.class, PacketDumpItemInfo::toBytes, PacketDumpItemInfo::new, PacketDumpItemInfo::handle);
        channel.registerMessageServer(startIndex++, PacketDumpBlockInfo.class, PacketDumpBlockInfo::toBytes, PacketDumpBlockInfo::new, PacketDumpBlockInfo::handle);
        channel.registerMessageClient(startIndex++, PacketSendClientCommand.class, PacketSendClientCommand::toBytes, PacketSendClientCommand::new, PacketSendClientCommand::handle);
        channel.registerMessageClient(startIndex++, PacketDataFromServer.class, PacketDataFromServer::toBytes, PacketDataFromServer::new, PacketDataFromServer::handle);
        channel.registerMessageClient(startIndex++, PacketSendGuiData.class, PacketSendGuiData::toBytes, PacketSendGuiData::new, PacketSendGuiData::handle);
        channel.registerMessageClient(startIndex++, PacketFinalizeLogin.class, PacketFinalizeLogin::toBytes, PacketFinalizeLogin::new, PacketFinalizeLogin::handle);
    }

    public static void sendCommand(SimpleNetworkWrapper network, String modid, String command, @Nonnull TypedMap arguments) {
        network.sendToServer((IMessage)new PacketSendServerCommand(modid, command, arguments));
    }
}

