/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.blocks.BlockGrating;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.util.blocks.BlockFluidBaseMP;

public abstract class BlockFluidLavaBaseMP
extends BlockFluidBaseMP {
    public BlockFluidLavaBaseMP(Fluid fluid) {
        super(fluid, Material.field_151587_i);
        this.setQuantaPerBlock(4);
        this.func_149711_c(100.0f);
        this.func_149752_b(100.0f);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != this) {
            return block.getLightValue(state, world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        block6: {
            super.func_180650_b(world, pos, state, rand);
            this.checkForMixing(world, pos, state);
            if (this.canFlowingInto(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b())) && this.field_149764_J == Material.field_151587_i && world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) {
                world.func_175656_a(pos.func_177977_b(), this.getBlockFromWaterTo());
                this.triggerMixEffects(world, pos.func_177977_b());
                return;
            }
            if (!world.func_82736_K().func_82766_b("doFireTick") || !this.enableFire()) break block6;
            int i = rand.nextInt(3);
            if (i > 0) {
                BlockPos blockpos1 = pos;
                for (int j = 0; j < i; ++j) {
                    if (world.func_180495_p(blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, 1, rand.nextInt(3) - 1)).func_185904_a() == Material.field_151579_a) {
                        if (!this.isSurroundingBlockFlammable(world, blockpos1)) continue;
                        world.func_175656_a(blockpos1, this.getFireBlock());
                        return;
                    }
                    if (!world.func_180495_p(blockpos1).func_185904_a().func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos2 = pos.func_177982_a(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1);
                    if (!world.func_175623_d(blockpos2.func_177984_a()) || !this.getCanBlockBurn(world, blockpos2)) continue;
                    world.func_175656_a(blockpos2.func_177984_a(), this.getFireBlock());
                }
            }
        }
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, neighborBlock, fromPos);
        this.checkForMixing(world, pos, state);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!this.checkForMixing(world, pos, state)) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    @Override
    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (((Boolean)this.displacements.get(block)).booleanValue()) {
                if (!(block instanceof BlockGrating)) {
                    this.triggerMixEffects(world, pos);
                    block.func_176226_b(world, pos, state, 0);
                }
                return true;
            }
            return false;
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            if (!(block instanceof BlockGrating)) {
                this.triggerMixEffects(world, pos);
                block.func_176226_b(world, pos, state, 0);
            }
            return true;
        }
        return this.density > density;
    }

    private boolean isSurroundingBlockFlammable(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            if (!this.getCanBlockBurn(world, pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76217_h();
    }

    protected boolean checkForMixing(World world, BlockPos pos, IBlockState state) {
        boolean flag = false;
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            if (enumfacing == EnumFacing.DOWN || world.func_180495_p(pos.func_177972_a(enumfacing)).func_185904_a() != Material.field_151586_h) continue;
            flag = true;
            break;
        }
        if (flag) {
            Integer integer = (Integer)state.func_177229_b((IProperty)LEVEL);
            if (integer == 0) {
                world.func_175656_a(pos, this.getObsidianBlock());
                this.triggerMixEffects(world, pos);
                return true;
            }
            if (integer <= 4) {
                world.func_175656_a(pos, this.getCobblestoneBlock());
                this.triggerMixEffects(world, pos);
                return true;
            }
        }
        return false;
    }

    private boolean canFlowingInto(World world, BlockPos pos, IBlockState state) {
        Material material = state.func_185904_a();
        return material != this.field_149764_J && material != Material.field_151587_i && !this.isBlocked(world, pos, state);
    }

    private boolean isBlocked(World world, BlockPos pos, IBlockState state) {
        return this.displacements.containsKey(state.func_177230_c()) && (Boolean)this.displacements.get(state.func_177230_c()) != false;
    }

    protected abstract IBlockState getBlockFromWaterTo();

    protected abstract IBlockState getObsidianBlock();

    protected abstract IBlockState getCobblestoneBlock();

    protected abstract IBlockState getFireBlock();

    protected abstract boolean enableFire();
}

