/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util;

import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.util.MPLog;
import stevekung.mods.moreplanets.util.helper.WorldDimensionHelper;
import stevekung.mods.moreplanets.world.IStartedDimension;

public class TeleportUtil {
    public static Entity teleportEntity(Entity entity, int dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportUtil.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, 0.0f, 0.0f);
    }

    public static Entity teleportEntity(Entity entity, int dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        MinecraftServer server = entity.func_184102_h();
        int sourceDim = entity.field_70170_p.field_73011_w.getDimension();
        if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
            return TeleportUtil.handleEntityTeleport(entity, server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
        return entity;
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, (int)targetDim)) {
            return entity;
        }
        if (interDimensional) {
            if (entity instanceof EntityPlayerMP) {
                return TeleportUtil.teleportPlayerInternational((EntityPlayerMP)entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
            return TeleportUtil.teleportEntityInternational(entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
            player.func_70034_d(yaw);
        } else {
            entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            entity.func_70034_d(yaw);
        }
        return entity;
    }

    private static Entity teleportEntityInternational(Entity entity, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity.field_70128_L) {
            return null;
        }
        WorldServer sourceWorld = server.func_71218_a(sourceDim);
        WorldServer targetWorld = server.func_71218_a(targetDim);
        if (!entity.field_70128_L && entity instanceof EntityMinecart) {
            entity.field_70128_L = true;
            entity.func_184204_a(targetDim);
            entity.field_70128_L = false;
        }
        entity.field_71093_bK = targetDim;
        sourceWorld.func_72900_e(entity);
        entity.field_70128_L = false;
        entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        sourceWorld.func_72866_a(entity, false);
        Entity newEntity = EntityList.func_191304_a(entity.getClass(), (World)targetWorld);
        if (newEntity != null) {
            newEntity.func_180432_n(entity);
            newEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            boolean flag = newEntity.field_98038_p;
            newEntity.field_98038_p = true;
            targetWorld.func_72838_d(newEntity);
            newEntity.field_98038_p = flag;
            targetWorld.func_72866_a(newEntity, false);
        }
        entity.field_70128_L = true;
        sourceWorld.func_82742_i();
        targetWorld.func_82742_i();
        return newEntity;
    }

    private static EntityPlayer teleportPlayerInternational(EntityPlayerMP player, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        WorldServer sourceWorld = server.func_71218_a(sourceDim);
        WorldServer targetWorld = server.func_71218_a(targetDim);
        PlayerList playerList = server.func_184103_al();
        player.field_71093_bK = targetDim;
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, targetWorld.func_175659_aa(), targetWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        playerList.func_187243_f(player);
        sourceWorld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        player.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
        targetWorld.func_72838_d((Entity)player);
        targetWorld.func_72866_a((Entity)player, false);
        player.func_70029_a((World)targetWorld);
        playerList.func_72375_a(player, sourceWorld);
        player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
        player.field_71134_c.func_73080_a(targetWorld);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        playerList.func_72354_b(player, targetWorld);
        playerList.func_72385_f(player);
        for (PotionEffect potion : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potion));
        }
        player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, sourceDim, targetDim);
        player.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        return player;
    }

    @Deprecated
    public static EntityPlayerMP setWarpDimension(EntityPlayerMP player, WorldServer world, int x, int y, int z, int dimID, boolean nether) {
        MinecraftServer mcServer;
        if (!world.field_72995_K && (mcServer = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
            WorldServer worldServer = mcServer.func_71218_a(dimID);
            if (worldServer == null) {
                MPLog.error("Cannot Transfer Entity to Dimension: Could not get World for Dimension {}", dimID);
                return null;
            }
            return TeleportUtil.teleportEntity((World)worldServer, player, x, y, z, dimID, nether);
        }
        return null;
    }

    @Deprecated
    private static EntityPlayerMP teleportEntity(World worldNew, EntityPlayerMP player, int x, int y, int z, int dimID, boolean nether) {
        BlockPos blockpos = player.getBedLocation(dimID);
        boolean flag = player.isSpawnForced(dimID);
        boolean dimChange = player.field_70170_p != worldNew;
        player.field_70170_p.func_72866_a((Entity)player, false);
        int oldDimID = GCCoreUtil.getDimensionID((World)player.field_70170_p);
        ChunkPos pair = worldNew.func_72964_e(x, z).func_76632_l();
        y = (int)((float)y + 1.5f);
        if (dimChange) {
            BlockPos blockpos1;
            World worldOld = player.field_70170_p;
            try {
                ((WorldServer)worldOld).func_184164_w().func_72695_c(player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            player.func_71053_j();
            player.field_71093_bK = dimID;
            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimID, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            worldOld.field_73010_i.remove(player);
            worldOld.func_72854_c();
            int i = player.field_70176_ah;
            int j = player.field_70164_aj;
            if (player.field_70175_ag && worldOld.func_175668_a(new BlockPos(i << 4, 63, j << 4), true)) {
                Chunk chunkOld = worldOld.func_72964_e(player.field_70176_ah, player.field_70164_aj);
                chunkOld.func_76622_b((Entity)player);
                chunkOld.func_177427_f(true);
            }
            worldOld.field_72996_f.remove(player);
            worldOld.func_72847_b((Entity)player);
            worldNew.func_72838_d((Entity)player);
            player.func_70029_a(worldNew);
            ((WorldServer)worldNew).func_72863_F().func_186028_c(pair.field_77276_a, pair.field_77275_b);
            worldNew.func_72866_a((Entity)player, false);
            if (!nether) {
                player.func_70012_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), player.field_70177_z, player.field_70125_A);
                player.field_71133_b.func_184103_al().func_72375_a(player, (WorldServer)worldNew);
                player.field_71135_a.func_147364_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), player.field_70177_z, player.field_70125_A);
            } else if (blockpos != null && (blockpos1 = EntityPlayer.func_180467_a((World)player.field_71133_b.func_71218_a(player.field_71093_bK), (BlockPos)blockpos, (boolean)flag)) != null) {
                player.func_70012_b((double)((float)blockpos1.func_177958_n() + 0.5f), (double)((float)blockpos1.func_177956_o() + 0.1f), (double)((float)blockpos1.func_177952_p() + 0.5f), 0.0f, 0.0f);
                player.func_180473_a(blockpos, flag);
            }
            player.field_71134_c.func_73080_a((WorldServer)worldNew);
            player.field_71133_b.func_184103_al().func_72354_b(player, (WorldServer)worldNew);
            player.field_71133_b.func_184103_al().func_72385_f(player);
            player.func_70095_a(false);
            for (Object o : player.func_70651_bq()) {
                PotionEffect potion = (PotionEffect)o;
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potion));
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        } else {
            player.func_71053_j();
            player.func_70095_a(false);
            worldNew.func_72866_a((Entity)player, false);
            player.field_71135_a.func_147364_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), player.field_70177_z, player.field_70125_A);
            player.func_70012_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), player.field_70177_z, player.field_70125_A);
            worldNew.func_72866_a((Entity)player, false);
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDimID, dimID);
        return player;
    }

    @Deprecated
    public static void startNewDimension(EntityPlayerMP player) {
        WorldServer worldOld = (WorldServer)player.field_70170_p;
        WorldServer worldNew = WorldDimensionHelper.getStartWorld(worldOld);
        BlockPos blockpos = worldNew.func_175672_r(worldNew.func_175694_M());
        boolean dimChange = player.field_70170_p != worldNew;
        player.field_70170_p.func_72866_a((Entity)player, false);
        int oldDimID = GCCoreUtil.getDimensionID((World)player.field_70170_p);
        ChunkPos pair = worldNew.func_72964_e(blockpos.func_177958_n(), blockpos.func_177952_p()).func_76632_l();
        if (dimChange) {
            try {
                worldOld.func_184164_w().func_72695_c(player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            player.func_71053_j();
            player.field_71093_bK = GCCoreUtil.getDimensionID((World)worldNew);
            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(GCCoreUtil.getDimensionID((World)worldNew), player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            worldOld.field_73010_i.remove(player);
            worldOld.func_72854_c();
            if (player.field_70175_ag && worldOld.func_72863_F().func_73149_a(player.field_70176_ah, player.field_70164_aj)) {
                Chunk chunkOld = worldOld.func_72964_e(player.field_70176_ah, player.field_70164_aj);
                chunkOld.func_76622_b((Entity)player);
                chunkOld.func_177427_f(true);
            }
            worldOld.field_72996_f.remove(player);
            worldOld.func_72847_b((Entity)player);
            worldNew.func_72838_d((Entity)player);
            player.func_70029_a((World)worldNew);
            MorePlanetsCore.PROXY.resetFloatingTick((EntityPlayer)player);
            if (!(worldNew.field_73011_w instanceof IGalacticraftWorldProvider)) {
                MPLog.error("{} is not space world!", ConfigManagerMP.startedPlanet);
                throw new RuntimeException(ConfigManagerMP.startedPlanet + " is not space world!");
            }
            if (worldNew.field_73011_w instanceof IStartedDimension) {
                IStartedDimension dimension = (IStartedDimension)worldNew.field_73011_w;
                MPLog.debug("Setting up player gear");
                dimension.setup(player);
            } else {
                GCPlayerStats stats = GCPlayerStats.get((Entity)player);
                MPLog.debug("Setting up player gear for Non-IStartedDimension world");
                SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(GCItems.schematic, 1, 1));
                SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(MarsItems.schematic, 1, 0));
                stats.getExtendedInventory().func_70299_a(0, new ItemStack(GCItems.oxMask, 1, 0));
                stats.getExtendedInventory().func_70299_a(1, new ItemStack(GCItems.oxygenGear, 1, 0));
                stats.getExtendedInventory().func_70299_a(2, new ItemStack(GCItems.oxTankHeavy, 1, 0));
                stats.getExtendedInventory().func_70299_a(3, new ItemStack(GCItems.oxTankHeavy, 1, 0));
                stats.getExtendedInventory().func_70299_a(5, new ItemStack(GCItems.basicItem, 1, 19));
                stats.getExtendedInventory().func_70299_a(6, new ItemStack(AsteroidsItems.thermalPadding, 1, 0));
                stats.getExtendedInventory().func_70299_a(7, new ItemStack(AsteroidsItems.thermalPadding, 1, 1));
                stats.getExtendedInventory().func_70299_a(8, new ItemStack(AsteroidsItems.thermalPadding, 1, 2));
                stats.getExtendedInventory().func_70299_a(9, new ItemStack(AsteroidsItems.thermalPadding, 1, 3));
                player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
                player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
                player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            }
            worldNew.func_72863_F().func_186028_c(pair.field_77276_a, pair.field_77275_b);
            worldNew.func_72866_a((Entity)player, false);
            player.func_70012_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o() + 16.0, (double)blockpos.func_177952_p(), player.field_70177_z, player.field_70125_A);
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, 5));
            player.field_71133_b.func_184103_al().func_72375_a(player, worldNew);
            player.field_71135_a.func_147364_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o() + 16.0, (double)blockpos.func_177952_p(), player.field_70177_z, player.field_70125_A);
            player.field_71134_c.func_73080_a(worldNew);
            player.field_71133_b.func_184103_al().func_72354_b(player, worldNew);
            player.field_71133_b.func_184103_al().func_72385_f(player);
            for (Object o : player.func_70651_bq()) {
                PotionEffect potion = (PotionEffect)o;
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potion));
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        } else {
            player.func_71053_j();
            worldNew.func_72866_a((Entity)player, false);
            player.field_71135_a.func_147364_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o() + 16.0, (double)blockpos.func_177952_p(), player.field_70177_z, player.field_70125_A);
            player.func_70012_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o() + 16.0, (double)blockpos.func_177952_p(), player.field_70177_z, player.field_70125_A);
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, 5));
            worldNew.func_72866_a((Entity)player, false);
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDimID, GCCoreUtil.getDimensionID((World)worldNew));
        if (player.field_70122_E && player.getBedLocation(GCCoreUtil.getDimensionID((World)player.field_70170_p)) == null) {
            int i = 30000000;
            int j = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70165_t + 0.5))));
            int k = Math.min(256, Math.max(0, MathHelper.func_76128_c((double)(player.field_70163_u + 1.5))));
            int l = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70161_v + 0.5))));
            BlockPos coords = new BlockPos(j, k, l);
            player.setSpawnChunk(coords, true, GCCoreUtil.getDimensionID((World)player.field_70170_p));
        }
    }
}

