/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.tileentity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import stevekung.mods.moreplanets.blocks.BlockTieredEnergyStorage;

public class TileEntityNuclearWasteStorageCluster
extends TileBaseUniversalElectricalSource
implements ISidedInventory,
IInventoryDefaults,
IConnector,
IMachineSides {
    private float nuclearWasteCapacity = 5.0E7f;
    public Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledEnergyLevel;
    public int lastScaledEnergyLevel;
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityNuclearWasteStorageCluster() {
        super("container.tiered_energy_storage_cluster_1.name");
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.setTierGC(4);
        this.storage.setCapacity(this.nuclearWasteCapacity);
        this.storage.setMaxExtract(7500.0f);
    }

    public int getPacketCooldown() {
        return 1;
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.scaledEnergyLevel = (int)Math.floor((this.getEnergyStoredGC() + 49.0f) * 16.0f / this.getMaxEnergyStoredGC());
        if (this.scaledEnergyLevel != this.lastScaledEnergyLevel) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
        }
        if (!this.field_145850_b.field_72995_K) {
            this.recharge((ItemStack)this.getInventory().get(0));
            this.recharge((ItemStack)this.getInventory().get(1));
            this.discharge((ItemStack)this.getInventory().get(2));
            this.discharge((ItemStack)this.getInventory().get(3));
            this.produce();
        }
        this.lastScaledEnergyLevel = this.scaledEnergyLevel;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readMachineSidesFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.addMachineSidesToNBT(nbt);
        return nbt;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            if (slot == 0 || slot == 1) {
                return ((ItemElectricBase)itemStack.func_77973_b()).getTransfer(itemStack) > 0.0f;
            }
            if (slot == 2 || slot == 3) {
                return ((ItemElectricBase)itemStack.func_77973_b()).getElectricityStored(itemStack) > 0.0f;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing side) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            if (slot == 0 || slot == 1) {
                return ((ItemElectricBase)itemStack.func_77973_b()).getTransfer(itemStack) <= 0.0f;
            }
            if (slot == 2 || slot == 3) {
                return ((ItemElectricBase)itemStack.func_77973_b()).getElectricityStored(itemStack) <= 0.0f || this.getEnergyStoredGC() >= this.getMaxEnergyStoredGC();
            }
        }
        return false;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.of(this.getElectricInputDirection());
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getElectricOutputDirection());
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return this.getElectricalInputDirections().contains(direction) || this.getElectricalOutputDirections().contains(direction);
    }

    public EnumFacing getFront() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockTieredEnergyStorage.FACING);
    }

    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case LEFT: {
                return this.getFront().func_176746_e();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176735_f();
    }

    public EnumFacing getElectricOutputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_OUT)) {
            case RIGHT: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176746_e();
    }

    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN, IMachineSides.MachineSide.ELECTRIC_OUT};
    }

    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.RIGHT, IMachineSides.Face.LEFT};
    }

    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    public IMachineSidesProperties getConfigurationType() {
        return BlockTieredEnergyStorage.MACHINESIDES_RENDERTYPE;
    }
}

