/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.world.gen.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;
import stevekung.mods.moreplanets.blocks.BlockSpaceDungeonSpawner;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.tileentity.TileEntityNibiruDungeonSpawner;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.dungeon.DungeonStartNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.dungeon.PieceNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.dungeon.SizedPieceNibiru;
import stevekung.mods.moreplanets.util.world.gen.dungeon.DungeonConfigurationMP;

public class RoomBossNibiru
extends SizedPieceNibiru {
    protected BlockPos chestPos;

    public RoomBossNibiru() {
    }

    public RoomBossNibiru(DungeonConfigurationMP configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir) {
        super(configuration, sizeX, sizeY, sizeZ, entranceDir.func_176734_d());
        this.func_186164_a(EnumFacing.SOUTH);
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
        this.sizeY = sizeY;
        int yPos = configuration.getYPosition();
        this.field_74887_e = new StructureBoundingBox(blockPosX, yPos, blockPosZ, blockPosX + this.sizeX, yPos + this.sizeY, blockPosZ + this.sizeZ);
    }

    public RoomBossNibiru(DungeonConfigurationMP configuration, Random rand, int blockPosX, int blockPosZ, EnumFacing entranceDir) {
        this(configuration, rand, blockPosX, blockPosZ, 24, 11, 24, entranceDir);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox boundingBox) {
        for (int i = 0; i <= this.sizeX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeZ; ++k) {
                    if (i == 0 || i == this.sizeX || j == 0 || k == 0 || k == this.sizeZ) {
                        int end;
                        int start;
                        boolean placeBlock = true;
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z) {
                            start = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - 1;
                            end = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 + 1;
                            if (i > start && i <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.SOUTH && k == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.NORTH && k == this.sizeZ) {
                                    placeBlock = false;
                                }
                            }
                        } else {
                            start = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
                            end = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1;
                            if (k > start && k <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.EAST && i == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.WEST && i == this.sizeX) {
                                    placeBlock = false;
                                }
                            }
                        }
                        if (placeBlock) {
                            this.func_175811_a(world, this.configuration.getBrickBlock(), i, j, k, boundingBox);
                            continue;
                        }
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                        continue;
                    }
                    if (j == this.sizeY) {
                        if ((i <= 2 || k <= 2 || i >= this.sizeX - 2 || k >= this.sizeZ - 2) && rand.nextInt(4) == 0) {
                            this.func_175811_a(world, this.configuration.getGlowstoneBlock(), i, j, k, boundingBox);
                            continue;
                        }
                        this.func_175811_a(world, this.configuration.getBrickBlock(), i, j, k, boundingBox);
                        continue;
                    }
                    if (j == 1 && (i <= 2 || k <= 2 || i >= this.sizeX - 2 || k >= this.sizeZ - 2)) {
                        if (rand.nextInt(4) == 0) {
                            this.func_175811_a(world, this.configuration.getGlowstoneBlock(), i, j - 1, k, boundingBox);
                        } else {
                            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                        }
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                        continue;
                    }
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                }
            }
        }
        int spawnerX = this.sizeX / 2;
        int spawnerY = 1;
        int spawnerZ = this.sizeZ / 2;
        this.func_175811_a(world, MPBlocks.SPACE_DUNGEON_SPAWNER.func_176223_P().func_177226_a(BlockSpaceDungeonSpawner.PLANET, (Comparable)((Object)BlockSpaceDungeonSpawner.DungeonType.NIBIRU)), spawnerX, spawnerY, spawnerZ, boundingBox);
        BlockPos blockpos = new BlockPos(this.func_74865_a(spawnerX, spawnerZ), this.func_74862_a(spawnerY), this.func_74873_b(spawnerX, spawnerZ));
        TileEntityNibiruDungeonSpawner spawner = (TileEntityNibiruDungeonSpawner)world.func_175625_s(blockpos);
        if (spawner == null) {
            spawner = new TileEntityNibiruDungeonSpawner();
            world.func_175690_a(blockpos, (TileEntity)spawner);
        }
        spawner.setRoom(new Vector3((double)(this.field_74887_e.field_78897_a + 1), (double)(this.field_74887_e.field_78895_b + 1), (double)(this.field_74887_e.field_78896_c + 1)), new Vector3((double)(this.sizeX - 1), (double)(this.sizeY - 1), (double)(this.sizeZ - 1)));
        spawner.setChestPos(this.chestPos);
        return true;
    }

    @Override
    public PieceNibiru getNextPiece(DungeonStartNibiru startPiece, Random rand) {
        return this.getCorridor(rand, startPiece, 10, true);
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("chestX", this.chestPos.func_177958_n());
        tagCompound.func_74768_a("chestY", this.chestPos.func_177956_o());
        tagCompound.func_74768_a("chestZ", this.chestPos.func_177952_p());
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        super.func_143011_b(tagCompound, manager);
        this.chestPos = new BlockPos(tagCompound.func_74762_e("chestX"), tagCompound.func_74762_e("chestY"), tagCompound.func_74762_e("chestZ"));
    }

    public BlockPos getChestPos() {
        return this.chestPos;
    }

    public void setChestPos(BlockPos chestPos) {
        this.chestPos = chestPos;
    }
}

