/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.core.GCItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.module.planets.nibiru.items.NibiruItems;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBasicMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;

public class BlockNibiruOre
extends BlockBasicMP
implements IDetectableResource,
IBlockVariants {
    private Random rand = new Random();
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockNibiruOre(String name) {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.NIBIRU_COAL_ORE)));
        this.func_149663_c(name);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (this.func_176201_c(world.func_180495_p(pos)) == 4) {
            this.activeRedstoneOre(world, pos);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.func_176201_c(state) == 4) {
            this.activeRedstoneOre(world, pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.func_176201_c(state) == 4) {
            this.activeRedstoneOre(world, pos);
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.func_176201_c(state) == 12) {
            world.func_180501_a(pos, this.func_176203_a(4), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.func_176201_c(state) == 12) {
            this.spawnRedstoneParticles(world, pos);
        }
    }

    private void activeRedstoneOre(World world, BlockPos pos) {
        this.spawnRedstoneParticles(world, pos);
        world.func_180501_a(pos, this.func_176203_a(12), 2);
    }

    private void spawnRedstoneParticles(World world, BlockPos pos) {
        Random random = world.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !world.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !world.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !world.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - d0;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            world.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected ItemStack func_180643_i(IBlockState state) {
        if (this.func_176201_c(state) == 12) {
            return new ItemStack((Block)this, 1, 4);
        }
        return super.func_180643_i(state);
    }

    public int func_149738_a(World world) {
        return 30;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length - 1; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return NibiruItems.NIBIRU_ITEM;
        }
        if (meta == 3) {
            return Items.field_151045_i;
        }
        if (meta == 4 || meta == 12) {
            return Items.field_151137_ax;
        }
        if (meta == 5) {
            return Items.field_151100_aR;
        }
        if (meta == 6) {
            return Items.field_151166_bC;
        }
        if (meta == 10) {
            return GCItems.basicItem;
        }
        if (meta == 11) {
            return NibiruItems.NIBIRU_ITEM;
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta == 5) {
            return 4;
        }
        if (meta == 0 || meta == 10) {
            return 2;
        }
        if (meta == 3 || meta == 4 || meta == 6 || meta == 11 || meta == 12) {
            return 0;
        }
        return meta;
    }

    public boolean isValueable(IBlockState state) {
        return true;
    }

    @Override
    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        int meta = this.func_176201_c(state);
        if (meta == 4 || meta == 12) {
            return 4 + rand.nextInt(2) + rand.nextInt(fortune + 1);
        }
        if (meta == 5) {
            return 4 + rand.nextInt(5);
        }
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_180660_a(state, rand, fortune)) {
            int j = rand.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return this.func_149745_a(rand) * (j + 1);
        }
        return super.quantityDropped(state, fortune, rand);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        int meta = this.func_176201_c(state);
        if (meta == 4 || meta == 11 || meta == 12) {
            return 1 + this.rand.nextInt(5);
        }
        if (meta == 0) {
            return MathHelper.func_76136_a((Random)this.rand, (int)0, (int)2);
        }
        if (meta == 3) {
            return MathHelper.func_76136_a((Random)this.rand, (int)3, (int)7);
        }
        if (meta == 5) {
            return MathHelper.func_76136_a((Random)this.rand, (int)2, (int)5);
        }
        if (meta == 6) {
            return MathHelper.func_76136_a((Random)this.rand, (int)3, (int)7);
        }
        return 0;
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("coal_ore", "iron_ore", "gold_ore", "diamond_ore", "redstone_ore", "lapis_ore", "emerald_ore", "aluminum_ore", "copper_ore", "tin_ore", "silicon_ore", "inferumite_crystal_ore", "redstone_ore");
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.ORE;
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.func_176201_c(state) == 12) {
            return new ItemStack((Block)this, 1, 4);
        }
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta % BlockType.valuesCached().length]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public static enum BlockType implements IStringSerializable
    {
        NIBIRU_COAL_ORE,
        NIBIRU_IRON_ORE,
        NIBIRU_GOLD_ORE,
        NIBIRU_DIAMOND_ORE,
        NIBIRU_REDSTONE_ORE,
        NIBIRU_LAPIS_ORE,
        NIBIRU_EMERALD_ORE,
        NIBIRU_ALUMINUM_ORE,
        NIBIRU_COPPER_ORE,
        NIBIRU_TIN_ORE,
        NIBIRU_SILICON_ORE,
        INFERUMITE_CRYSTAL_ORE,
        NIBIRU_REDSTONE_ORE_ACTIVE;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

