/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.fronos.blocks;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBreakableMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;
import stevekung.mods.moreplanets.util.helper.ColorHelper;

public class BlockJelly
extends BlockBreakableMP
implements IBlockVariants {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);
    private static final Map<BlockType, float[]> JELLY_RGB = new EnumMap<BlockType, float[]>(BlockType.class);

    public BlockJelly(String name) {
        super(Material.field_151580_n);
        this.setSoundType(MPSounds.SMALL_SLIME);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.GRAPE_JELLY_BLOCK)));
        this.func_149663_c(name);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        return JELLY_RGB.get(state.func_177229_b(VARIANT));
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION_BLOCK;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.func_70093_af()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        } else {
            entity.func_180430_e(fallDistance, 0.0f);
        }
    }

    public void func_176216_a(World world, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(world, entity);
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70181_x = -entity.field_70181_x;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.8;
            }
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (Math.abs(entity.field_70181_x) < 0.1 && !entity.func_70093_af()) {
            double d0 = 0.4 + Math.abs(entity.field_70181_x) * 0.2;
            entity.field_70159_w *= d0;
            entity.field_70179_y *= d0;
        }
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta % BlockType.valuesCached().length]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("grape", "raspberry", "strawberry", "berry", "lime", "orange", "green", "lemon");
    }

    @Override
    protected boolean isTranslucent() {
        return true;
    }

    @Override
    protected boolean renderSideWithState() {
        return true;
    }

    public boolean isStickyBlock(IBlockState state) {
        return true;
    }

    static {
        JELLY_RGB.put(BlockType.GRAPE_JELLY_BLOCK, ColorHelper.rgbToFloatArray(230, 77, 201));
        JELLY_RGB.put(BlockType.RASPBERRY_JELLY_BLOCK, ColorHelper.rgbToFloatArray(250, 68, 112));
        JELLY_RGB.put(BlockType.STRAWBERRY_JELLY_BLOCK, ColorHelper.rgbToFloatArray(247, 102, 103));
        JELLY_RGB.put(BlockType.BERRY_JELLY_BLOCK, ColorHelper.rgbToFloatArray(122, 47, 198));
        JELLY_RGB.put(BlockType.LIME_JELLY_BLOCK, ColorHelper.rgbToFloatArray(197, 254, 136));
        JELLY_RGB.put(BlockType.ORANGE_JELLY_BLOCK, ColorHelper.rgbToFloatArray(255, 144, 32));
        JELLY_RGB.put(BlockType.GREEN_JELLY_BLOCK, ColorHelper.rgbToFloatArray(47, 151, 47));
        JELLY_RGB.put(BlockType.LEMON_JELLY_BLOCK, ColorHelper.rgbToFloatArray(183, 221, 67));
    }

    public static enum BlockType implements IStringSerializable
    {
        GRAPE_JELLY_BLOCK,
        RASPBERRY_JELLY_BLOCK,
        STRAWBERRY_JELLY_BLOCK,
        BERRY_JELLY_BLOCK,
        LIME_JELLY_BLOCK,
        ORANGE_JELLY_BLOCK,
        GREEN_JELLY_BLOCK,
        LEMON_JELLY_BLOCK;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

