/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.diona.world.gen.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import stevekung.mods.moreplanets.blocks.BlockSpaceDungeonSpawner;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.module.planets.diona.blocks.DionaBlocks;
import stevekung.mods.moreplanets.module.planets.diona.tileentity.TileEntityDionaDungeonSpawner;
import stevekung.mods.moreplanets.util.world.gen.dungeon.CorridorMP;
import stevekung.mods.moreplanets.util.world.gen.dungeon.DungeonConfigurationMP;
import stevekung.mods.moreplanets.util.world.gen.dungeon.DungeonStartMP;
import stevekung.mods.moreplanets.util.world.gen.dungeon.PieceMP;
import stevekung.mods.moreplanets.util.world.gen.dungeon.RoomBossMP;

public class RoomBossDiona
extends RoomBossMP {
    public RoomBossDiona() {
    }

    public RoomBossDiona(DungeonConfigurationMP configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir) {
        super(configuration, rand, blockPosX, blockPosZ, sizeX, sizeY, sizeZ, entranceDir);
    }

    public RoomBossDiona(DungeonConfigurationMP configuration, Random rand, int blockPosX, int blockPosZ, EnumFacing entranceDir) {
        super(configuration, rand, blockPosX, blockPosZ, 24, 11, 24, entranceDir);
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox boundingBox) {
        for (int i = 0; i <= this.sizeX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeZ; ++k) {
                    if (i == 0 || i == this.sizeX || j == 0 || k == 0 || k == this.sizeZ) {
                        int end;
                        int start;
                        boolean placeBlock = true;
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z) {
                            start = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - 1;
                            end = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 + 1;
                            if (i > start && i <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.SOUTH && k == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.NORTH && k == this.sizeZ) {
                                    placeBlock = false;
                                }
                            }
                        } else {
                            start = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
                            end = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1;
                            if (k > start && k <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.EAST && i == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.WEST && i == this.sizeX) {
                                    placeBlock = false;
                                }
                            }
                        }
                        if (placeBlock) {
                            this.func_175811_a(world, this.configuration.getBrickBlock(), i, j, k, boundingBox);
                            continue;
                        }
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                        continue;
                    }
                    if (j == this.sizeY) {
                        if ((i <= 2 || k <= 2 || i >= this.sizeX - 2 || k >= this.sizeZ - 2) && rand.nextInt(4) == 0) {
                            this.func_175811_a(world, this.configuration.getGlowstoneBlock(), i, j, k, boundingBox);
                            continue;
                        }
                        this.func_175811_a(world, this.configuration.getBrickBlock(), i, j, k, boundingBox);
                        continue;
                    }
                    if (j == 1 && (i <= 2 || k <= 2 || i >= this.sizeX - 2 || k >= this.sizeZ - 2)) {
                        if (rand.nextInt(4) == 0) {
                            this.func_175811_a(world, this.configuration.getGlowstoneBlock(), i, j - 1, k, boundingBox);
                        } else {
                            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                        }
                        if (rand.nextInt(6) == 0) {
                            this.func_175811_a(world, DionaBlocks.ZELIUS_EGG.func_176223_P(), i, j, k, boundingBox);
                            continue;
                        }
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                        continue;
                    }
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                }
            }
        }
        int spawnerX = this.sizeX / 2;
        int spawnerY = 1;
        int spawnerZ = this.sizeZ / 2;
        this.func_175811_a(world, MPBlocks.SPACE_DUNGEON_SPAWNER.func_176223_P().func_177226_a(BlockSpaceDungeonSpawner.PLANET, (Comparable)((Object)BlockSpaceDungeonSpawner.DungeonType.DIONA)), spawnerX, spawnerY, spawnerZ, boundingBox);
        BlockPos blockpos = new BlockPos(this.func_74865_a(spawnerX, spawnerZ), this.func_74862_a(spawnerY), this.func_74873_b(spawnerX, spawnerZ));
        TileEntityDionaDungeonSpawner spawner = (TileEntityDionaDungeonSpawner)world.func_175625_s(blockpos);
        if (spawner == null) {
            spawner = new TileEntityDionaDungeonSpawner();
            world.func_175690_a(blockpos, (TileEntity)spawner);
        }
        spawner.setRoom(new Vector3((double)(this.field_74887_e.field_78897_a + 1), (double)(this.field_74887_e.field_78895_b + 1), (double)(this.field_74887_e.field_78896_c + 1)), new Vector3((double)(this.sizeX - 1), (double)(this.sizeY - 1), (double)(this.sizeZ - 1)));
        spawner.setChestPos(this.chestPos);
        return true;
    }

    @Override
    public PieceMP getCorridor(Random rand, DungeonStartMP startPiece, int maxAttempts, boolean small) {
        int sizeZ;
        int sizeX;
        int blockZ;
        int blockX;
        EnumFacing randomDir;
        StructureBoundingBox extension;
        boolean valid;
        int attempts = maxAttempts;
        do {
            int randDir;
            randomDir = EnumFacing.func_176731_b((int)(((randDir = rand.nextInt(4)) == this.getDirection().func_176734_d().func_176736_b() ? randDir + 1 : randDir) % 4));
            extension = this.getExtension(randomDir, this.configuration.getHallwayLengthMin() + rand.nextInt(this.configuration.getHallwayLengthMax() - this.configuration.getHallwayLengthMin()), 3);
            blockX = extension.field_78897_a;
            blockZ = extension.field_78896_c;
            sizeX = extension.field_78893_d - extension.field_78897_a;
            sizeZ = extension.field_78892_f - extension.field_78896_c;
        } while (!(valid = !startPiece.checkIntersection(extension)) && --attempts > 0);
        if (!valid) {
            return null;
        }
        return new CorridorMP(this.configuration, rand, blockX, blockZ, sizeX, small ? 3 : this.configuration.getHallwayHeight(), sizeZ, randomDir);
    }
}

