/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.diona.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import stevekung.mods.moreplanets.module.planets.diona.blocks.BlockCrashedAlienProbe;
import stevekung.mods.moreplanets.module.planets.diona.blocks.DionaBlocks;
import stevekung.mods.moreplanets.util.tileentity.TileEntityRenderTickable;

public class TileEntityCrashedAlienProbe
extends TileEntityRenderTickable
implements IInventory {
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    private NonNullList<ItemStack> containingItems = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);

    public TileEntityCrashedAlienProbe() {
        this.isContainer = true;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.func_180495_p(this.func_174877_v()) == DionaBlocks.CRASHED_ALIEN_PROBE.func_176223_P().func_177226_a((IProperty)BlockCrashedAlienProbe.HAS_ALIEN, (Comparable)Boolean.valueOf(true))) {
            super.func_73660_a();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (!this.checkLootAndRead(nbt)) {
            this.containingItems = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.containingItems);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.checkLootAndWrite(nbt)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.containingItems);
        }
        return nbt;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"container.crashed_probe.name");
    }

    public int func_70302_i_() {
        return this.containingItems.size();
    }

    public ItemStack func_70301_a(int slot) {
        this.fillWithLoot(null);
        return (ItemStack)this.containingItems.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.fillWithLoot(null);
        ItemStack itemStack = ItemStackHelper.func_188382_a(this.containingItems, (int)index, (int)count);
        if (!itemStack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int index) {
        this.fillWithLoot(null);
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.containingItems, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        this.fillWithLoot(null);
        this.containingItems.set(index, (Object)itemStack);
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        this.fillWithLoot(null);
        for (ItemStack itemStack : this.containingItems) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_145818_k_() {
        return false;
    }

    protected void fillWithLoot(@Nullable EntityPlayer player) {
        if (this.lootTable != null) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            Random random = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                lootcontext$builder.func_186469_a(player.func_184817_da());
            }
            loottable.func_186460_a((IInventory)this, random, lootcontext$builder.func_186471_a());
        }
    }

    protected boolean checkLootAndRead(NBTTagCompound compound) {
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean checkLootAndWrite(NBTTagCompound compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
            return true;
        }
        return false;
    }

    public void setLootTable(ResourceLocation lootTable, long seed) {
        this.lootTable = lootTable;
        this.lootTableSeed = seed;
    }
}

