/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.diona.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.module.planets.diona.inventory.ContainerDarkEnergyGenerator;
import stevekung.mods.moreplanets.module.planets.diona.tileentity.TileEntityDarkEnergyGenerator;
import stevekung.mods.moreplanets.util.client.gui.GuiContainerMP;
import stevekung.mods.moreplanets.util.client.gui.GuiElementInfoRegionMP;

public class GuiDarkEnergyGenerator
extends GuiContainerMP {
    private static final ResourceLocation TEXTURE = new ResourceLocation("moreplanets:textures/gui/dark_energy_generator.png");
    private final TileEntityDarkEnergyGenerator tile;
    private GuiButton buttonEnable;
    private GuiElementInfoRegionMP electricInfoRegion;

    public GuiDarkEnergyGenerator(InventoryPlayer invPlayer, TileEntityDarkEnergyGenerator tile) {
        super(new ContainerDarkEnergyGenerator(invPlayer, tile));
        this.tile = tile;
        this.field_147000_g = 201;
        this.field_146999_f = 176;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.tile.getEnergyStoredGC()) + " / " + (int)Math.floor(this.tile.getMaxEnergyStoredGC()));
        this.electricInfoRegion = new GuiElementInfoRegionMP((this.field_146294_l - this.field_146999_f) / 2 + 51, (this.field_146295_m - this.field_147000_g) / 2 + 24, 54, 9, electricityDesc, this.field_146294_l, this.field_146295_m, this);
        this.infoRegions.add(this.electricInfoRegion);
        this.infoRegions.add(new GuiElementInfoRegionMP((this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 84, 18, 18, Arrays.asList(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"), GCCoreUtil.translate((String)"gui.battery_slot.desc.1")), this.field_146294_l, this.field_146295_m, this));
        this.infoRegions.add(new GuiElementInfoRegionMP((this.field_146294_l - this.field_146999_f) / 2 + 25, (this.field_146295_m - this.field_147000_g) / 2 + 84, 18, 18, Arrays.asList(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"), GCCoreUtil.translate((String)"gui.battery_slot.desc.1")), this.field_146294_l, this.field_146295_m, this));
        this.buttonEnable = new GuiButton(0, this.field_146294_l / 2 + 5, this.field_146295_m / 2 - 18, 72, 20, !this.tile.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.disable.name") : GCCoreUtil.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnable);
        this.buttonEnable.field_146124_l = this.tile.disableCooldown == 0;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int offsetY = 33;
        this.buttonEnable.field_146124_l = this.tile.disableCooldown == 0;
        this.buttonEnable.field_146126_j = !this.tile.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.disable.name") : GCCoreUtil.translate((String)"gui.button.enable.name");
        String displayString = this.tile.func_70005_c_();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 7, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 23 + offsetY, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.generating.name") + ": " + (this.tile.generateWatts > 0 ? EnergyDisplayHelper.getEnergyDisplayS((float)this.tile.generateWatts) + "/t" : GCCoreUtil.translate((String)"gui.status.not_generating.name"));
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 11 + offsetY, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.status.dark_energy_fuel.name") + ": " + String.valueOf(this.tile.darkEnergyFuel * 100 / 1000) + "%";
        if (this.tile.darkEnergyFuel == 0) {
            displayString = GCCoreUtil.translate((String)"gui.status.dark_energy_fuel.name") + ": " + TextFormatting.GOLD + GCCoreUtil.translate((String)"gui.status.empty.name");
        }
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 35 + offsetY, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int width = (this.field_146294_l - this.field_146999_f) / 2;
        int height = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(width, height, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(width + 37, height + 24, 176, 0, 11, 10);
        }
        if (this.tile.darkEnergyFuel > 0) {
            int i = this.getFuelBurnLeftScaled(19);
            this.func_73729_b(width + 119, height + 37 - i, 176, 19 - i + 10, 32, i);
        }
        this.func_73729_b(width + 51, height + 25, 187, 0, Math.min(this.tile.getScaledElecticalLevel(54), 54), 7);
    }

    private String getStatus() {
        if (this.tile.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (this.tile.generateWatts > 0) {
            return EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.collectingenergy.name");
        }
        return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.unknown.name");
    }

    private int getFuelBurnLeftScaled(int pixels) {
        int i = this.tile.prevDarkEnergyFuel;
        if (i == 0) {
            i = 1000;
        }
        return this.tile.darkEnergyFuel * pixels / i;
    }
}

