/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.diona.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.module.planets.diona.items.DionaItems;
import stevekung.mods.moreplanets.module.planets.diona.tileentity.TileEntityInfectedCrystallizeEnderCore;
import stevekung.mods.moreplanets.util.CompatibilityManagerMP;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBaseMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;
import stevekung.mods.moreplanets.util.tileentity.TileEntityNull;

public class BlockInfectedCrystallizePart
extends BlockBaseMP
implements IBlockVariants,
ITileEntityProvider {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockInfectedCrystallizePart(String name) {
        super(Material.field_151578_c);
        this.func_149711_c(0.5f);
        this.func_149752_b(50.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.INFECTED_CRYSTALLIZE_BLOCK)));
        this.func_149663_c(name);
        this.setSoundType(MPSounds.ALIEN_EGG);
        this.setDefaultSlipperiness(0.8f);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.func_70093_af()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        } else {
            entity.func_180430_e(fallDistance, 0.0f);
        }
    }

    public void func_176216_a(World world, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(world, entity);
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70181_x = -entity.field_70181_x;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.8;
            }
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (Math.abs(entity.field_70181_x) < 0.1 && !entity.func_70093_af()) {
            double d0 = 0.4 + Math.abs(entity.field_70181_x) * 0.2;
            entity.field_70159_w *= d0;
            entity.field_70179_y *= d0;
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (state.func_177229_b(VARIANT) == BlockType.INFECTED_CRYSTALLIZE_BLOCK && !heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() == DionaItems.INFECTED_CRYSTALLIZE_SLIMEBALL) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                world.func_175656_a(pos, this.func_176203_a(1));
                return true;
            }
            if (heldItem.func_77973_b() == Items.field_151061_bv) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                world.func_175656_a(pos, this.func_176203_a(2));
                return true;
            }
        }
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return CompatibilityManagerMP.isCTMLoaded && state.func_177229_b(VARIANT) != BlockType.INFECTED_CRYSTALLIZE_BLOCK ? layer == BlockRenderLayer.CUTOUT : layer == BlockRenderLayer.SOLID;
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("default", "eye_core", "ender_core");
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION_NON_BLOCK;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta % BlockType.valuesCached().length]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return meta == 2 ? new TileEntityInfectedCrystallizeEnderCore() : new TileEntityNull();
    }

    public static enum BlockType implements IStringSerializable
    {
        INFECTED_CRYSTALLIZE_BLOCK,
        INFECTED_CRYSTALLIZE_EYE_CORE,
        INFECTED_CRYSTALLIZE_ENDER_CORE;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

