/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.chalos.entity;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.module.planets.chalos.blocks.ChalosBlocks;
import stevekung.mods.moreplanets.module.planets.chalos.entity.EntityCheeseFloater;
import stevekung.mods.moreplanets.module.planets.chalos.entity.projectile.EntityCheeseSpore;
import stevekung.mods.moreplanets.module.planets.chalos.items.ChalosItems;
import stevekung.mods.moreplanets.util.IMorePlanetsBoss;
import stevekung.mods.moreplanets.util.JsonUtil;
import stevekung.mods.moreplanets.util.entity.EntityFlyingBossMP;
import stevekung.mods.moreplanets.util.helper.ColorHelper;
import stevekung.mods.moreplanets.util.tileentity.TileEntityTreasureChestMP;

public class EntityCheeseCubeEyeBoss
extends EntityFlyingBossMP
implements IEntityBreathable,
IMorePlanetsBoss {
    private TileEntityDungeonSpawner<?> spawner;
    private Entity targetedEntity;
    public int deathTicks = 0;
    public int attackCounter;
    public int prevAttackCounter;
    public int entitiesWithin;
    public int entitiesWithinLast;
    private int spawnCount = 10;
    private BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);

    public EntityCheeseCubeEyeBoss(World world) {
        super(world);
        this.func_70105_a(1.8f, 2.0f);
        this.field_70765_h = new GhastMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AICheeseSporeAttack(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(750.0 * ConfigManagerCore.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("SpawnCount", this.spawnCount);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("SpawnCount", 99)) {
            this.spawnCount = nbt.func_74762_e("SpawnCount");
        }
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
    }

    public void func_70653_a(Entity entity, float strength, double x, double z) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        this.bossInfo.func_186761_b(player);
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 180 && this.deathTicks % 5 == 0) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_EXPLODE, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[0]), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int j;
                for (int i = 150; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 40) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[]{Float.valueOf(this.func_70647_i() - 0.1f)}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
        }
        this.func_70091_d(MoverType.SELF, 0.0, -0.1f, 0.0);
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            double dist;
            TileEntity chestTest;
            int j;
            for (int i = 150; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            TileEntityTreasureChestMP chest = null;
            if (this.spawner != null && this.spawner.getChestPos() != null && (chestTest = this.field_70170_p.func_175625_s(this.spawner.getChestPos())) != null && chestTest instanceof TileEntityTreasureChestMP) {
                chest = (TileEntityTreasureChestMP)chestTest;
            }
            if (chest == null) {
                chest = TileEntityTreasureChestMP.findClosest((Entity)this, 5);
            }
            if (chest != null && (dist = this.func_70092_e((double)chest.func_174877_v().func_177958_n() + 0.5, (double)chest.func_174877_v().func_177956_o() + 0.5, (double)chest.func_174877_v().func_177952_p() + 0.5)) < 1000000.0) {
                if (!chest.locked) {
                    chest.locked = true;
                }
                int slot = this.field_70146_Z.nextInt(chest.func_70302_i_());
                chest.setLootTable(MPLootTables.COMMON_SPACE_DUNGEON, this.field_70146_Z.nextLong());
                chest.func_70299_a(slot, MPLootTables.getTieredKey(this.field_70146_Z, 5));
            }
            this.func_70099_a(new ItemStack(ChalosItems.CHALOS_DUNGEON_KEY, 1, 0), 0.5f);
            super.func_70106_y();
            if (this.spawner != null) {
                this.spawner.isBossDefeated = true;
                this.spawner.boss = null;
                this.spawner.spawned = false;
            }
        }
    }

    public void func_70106_y() {
        MorePlanetsCore.PROXY.removeBoss(this);
        super.func_70106_y();
    }

    public void func_70636_d() {
        EntityPlayer player = this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 256.0, false);
        if (player != null && !player.equals((Object)this.targetedEntity) && !player.field_71075_bZ.field_75098_d) {
            if (this.func_70068_e((Entity)player) < 400.0) {
                this.func_70661_as().func_75494_a((Entity)player);
                this.targetedEntity = player;
            }
        } else {
            this.targetedEntity = null;
        }
        if (this.spawner != null) {
            List playersWithin = this.field_70170_p.func_72872_a(EntityPlayer.class, this.spawner.getRangeBounds());
            this.entitiesWithin = playersWithin.size();
            if (this.entitiesWithin == 0 && this.entitiesWithinLast != 0) {
                List playerWithin = this.field_70170_p.func_72872_a(EntityPlayer.class, this.spawner.getRangeBoundsPlus11());
                for (EntityPlayer player2 : playerWithin) {
                    JsonUtil json = new JsonUtil();
                    player2.func_145747_a(new JsonUtil().text(GCCoreUtil.translate((String)"gui.skeleton_boss.message")).func_150255_a(json.red()));
                }
                this.func_70106_y();
                return;
            }
            this.entitiesWithinLast = this.entitiesWithin;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        MorePlanetsCore.PROXY.addBoss(this);
        if (this.func_110143_aJ() <= 0.0f) {
            return;
        }
        if (this.spawnCount > 0 && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.spawner != null && this.field_70173_aa % 100 == 0) {
            EntityCheeseFloater tentacle1 = new EntityCheeseFloater(this.field_70170_p);
            tentacle1.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v + 2.0, 0.0f, 0.0f);
            tentacle1.func_110149_m(25.0f);
            tentacle1.setMinion(true);
            if (tentacle1.func_70601_bi() && tentacle1.func_70058_J()) {
                this.field_70170_p.func_72838_d((Entity)tentacle1);
            }
            EntityCheeseFloater tentacle2 = new EntityCheeseFloater(this.field_70170_p);
            tentacle2.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u, this.field_70161_v - 2.0, 0.0f, 0.0f);
            tentacle2.func_110149_m(25.0f);
            tentacle2.setMinion(true);
            if (tentacle2.func_70601_bi() && tentacle2.func_70058_J()) {
                this.field_70170_p.func_72838_d((Entity)tentacle2);
            }
            EntityCheeseFloater tentacle3 = new EntityCheeseFloater(this.field_70170_p);
            tentacle3.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 2.0, 0.0f, 0.0f);
            tentacle3.func_110149_m(25.0f);
            tentacle3.setMinion(true);
            if (tentacle3.func_70601_bi() && tentacle3.func_70058_J()) {
                this.field_70170_p.func_72838_d((Entity)tentacle3);
            }
            EntityCheeseFloater tentacle4 = new EntityCheeseFloater(this.field_70170_p);
            tentacle4.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u, this.field_70161_v + 2.0, 0.0f, 0.0f);
            tentacle4.func_110149_m(25.0f);
            tentacle4.setMinion(true);
            if (tentacle4.func_70601_bi() && tentacle4.func_70058_J()) {
                this.field_70170_p.func_72838_d((Entity)tentacle4);
            }
            --this.spawnCount;
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76355_l().contains("arrow")) {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
                for (int i = 0; i < 16; ++i) {
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 10, (double)(this.field_70130_N / 4.0f), (double)(this.field_70131_O / 4.0f), (double)(this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)ChalosBlocks.CHEESE_SLIME_BLOCK.func_176223_P())});
                }
            }
            if (this.func_180431_b(source)) {
                return false;
            }
            if (super.func_70097_a(source, damage)) {
                Entity entity = source.func_76346_g();
                if (this.func_184188_bt().contains(entity) && this.func_184187_bx() != entity) {
                    if (entity != this) {
                        this.targetedEntity = entity;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187880_fp;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    protected void func_70628_a(boolean drop, int fortune) {
        int i;
        int j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + fortune);
        for (i = 0; i < j; ++i) {
            this.func_70099_a(new ItemStack(ChalosItems.CHEESE_SLIMEBALL, 1), 0.0f);
        }
        for (i = 0; i < this.field_70146_Z.nextInt(3); ++i) {
            this.func_70099_a(new ItemStack(ChalosItems.CHEESE_FOOD, 1), 0.0f);
        }
    }

    public boolean canBreath() {
        return true;
    }

    public void onBossSpawned(TileEntityDungeonSpawner spawner) {
        this.spawner = spawner;
    }

    @Override
    public UUID getBossUUID() {
        return this.bossInfo.func_186737_d();
    }

    @Override
    public String getBossName() {
        return this.func_70005_c_();
    }

    @Override
    public String getBossType() {
        return "Chalos Boss";
    }

    @Override
    public int getBossTextColor() {
        return ColorHelper.rgbToDecimal(246, 220, 160);
    }

    private static class GhastMoveHelper
    extends EntityMoveHelper {
        private EntityCheeseCubeEyeBoss entity;
        private int courseChangeCooldown;

        public GhastMoveHelper(EntityCheeseCubeEyeBoss entity) {
            super((EntityLiving)entity);
            this.entity = entity;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.entity.field_70165_t;
                double d1 = this.field_75647_c - this.entity.field_70163_u;
                double d2 = this.field_75644_d - this.entity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.entity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.entity.field_70159_w += d0 / d3 * 0.1;
                        this.entity.field_70181_x += d1 / d3 * 0.1;
                        this.entity.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double distance) {
            double d0 = (x - this.entity.field_70165_t) / distance;
            double d1 = (y - this.entity.field_70163_u) / distance;
            double d2 = (z - this.entity.field_70161_v) / distance;
            AxisAlignedBB axisalignedbb = this.entity.func_174813_aQ();
            int i = 1;
            while ((double)i < distance) {
                if (!this.entity.field_70170_p.func_184144_a((Entity)this.entity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class AIRandomFly
    extends EntityAIBase {
        private EntityCheeseCubeEyeBoss entity;

        public AIRandomFly(EntityCheeseCubeEyeBoss entity) {
            this.entity = entity;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.entity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.entity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.entity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.entity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.entity.func_70681_au();
            double d0 = this.entity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.entity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.entity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.entity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    private static class AILookAround
    extends EntityAIBase {
        private EntityCheeseCubeEyeBoss entity;

        public AILookAround(EntityCheeseCubeEyeBoss entity) {
            this.entity = entity;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.entity.func_70638_az() == null) {
                this.entity.field_70761_aq = this.entity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.entity.field_70159_w, (double)this.entity.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.entity.func_70638_az();
                if (entitylivingbase.func_70068_e((Entity)this.entity) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.entity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.entity.field_70161_v;
                    this.entity.field_70761_aq = this.entity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    private static class AICheeseSporeAttack
    extends EntityAIBase {
        private EntityCheeseCubeEyeBoss parentEntity;
        public int attackTimer;

        public AICheeseSporeAttack(EntityCheeseCubeEyeBoss ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 20) {
                    Vec3d vec3d = this.parentEntity.func_70676_i(1.0f);
                    double d2 = entitylivingbase.field_70165_t - (this.parentEntity.field_70165_t + vec3d.field_72450_a * 4.0);
                    double d3 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (0.5 + this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
                    double d4 = entitylivingbase.field_70161_v - (this.parentEntity.field_70161_v + vec3d.field_72449_c * 4.0);
                    world.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this.parentEntity), 0);
                    EntityCheeseSpore cheeseSpore = new EntityCheeseSpore(world, (EntityLivingBase)this.parentEntity, d2, d3, d4);
                    cheeseSpore.field_70165_t = this.parentEntity.field_70165_t + vec3d.field_72450_a * 4.0;
                    cheeseSpore.field_70163_u = this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f) + 0.5;
                    cheeseSpore.field_70161_v = this.parentEntity.field_70161_v + vec3d.field_72449_c * 4.0;
                    world.func_72838_d((Entity)cheeseSpore);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }
}

