/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.event;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.data.WorldDataStartedDimension;
import stevekung.mods.moreplanets.module.planets.diona.dimension.WorldProviderDiona;
import stevekung.mods.moreplanets.module.planets.diona.entity.EntityAlienBeam;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.dimension.WorldProviderNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.weather.EntityNibiruLightningBolt;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.biome.BiomeGreenVein;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.biome.BiomeInfectedDesert;

public class WorldTickEventHandler {
    private int updateLCG = new Random().nextInt();
    public static WorldDataStartedDimension startedDimensionData = null;

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        block8: {
            int l;
            World world;
            block9: {
                world = event.world;
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                l = this.updateLCG >> 2;
                if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START) break block8;
                if (DimensionManager.getWorld((int)ConfigManagerMP.idDimensionDiona) == null) break block9;
                Iterator iterator = world.getPersistentChunkIterable(((WorldServer)world).func_184164_w().func_187300_b());
                while (iterator.hasNext()) {
                    Chunk chunk = (Chunk)iterator.next();
                    int x = chunk.field_76635_g * 16;
                    int z = chunk.field_76647_h * 16;
                    BlockPos strikePos = new BlockPos(x + (l & 0xF), 0, z + (l >> 8 & 0xF));
                    BlockPos pos = this.adjustPosToNearbyEntity(world, strikePos);
                    if (!(world.field_73011_w instanceof WorldProviderDiona) || !this.canBeamStrike(world, pos) || world.field_73012_v.nextInt(75000) != 0) continue;
                    EntityAlienBeam beam = new EntityAlienBeam(world);
                    beam.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0f, 0.0f);
                    if (!world.func_175667_e(pos)) continue;
                    world.func_72838_d((Entity)beam);
                }
                break block8;
            }
            if (DimensionManager.getWorld((int)ConfigManagerMP.idDimensionNibiru) == null) break block8;
            Iterator iterator = world.getPersistentChunkIterable(((WorldServer)world).func_184164_w().func_187300_b());
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                int x = chunk.field_76635_g * 16;
                int z = chunk.field_76647_h * 16;
                BlockPos strikePos = new BlockPos(x + (l & 0xF), 0, z + (l >> 8 & 0xF));
                BlockPos pos = this.adjustPosToNearbyEntity(world, strikePos);
                if (!(world.field_73011_w instanceof WorldProviderNibiru)) continue;
                boolean raining = world.func_72896_J();
                boolean thunder = world.func_72911_I();
                Biome biome = world.func_180494_b(pos);
                EntityNibiruLightningBolt bolt = new EntityNibiruLightningBolt(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), false);
                EntityNibiruLightningBolt boltFire = new EntityNibiruLightningBolt(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), true);
                if (world.field_73011_w.canDoLightning(chunk) && raining && thunder && world.field_73012_v.nextInt(1000) == 0 && world.func_175727_C(pos)) {
                    world.func_72838_d((Entity)boltFire);
                }
                if (world.field_73012_v.nextInt(16) == 0) {
                    BlockPos pos1 = pos.func_177977_b();
                    if (world.func_175697_a(pos1, 1) && world.func_175662_w(pos1)) {
                        world.func_175656_a(pos1, NibiruBlocks.INFECTED_ICE.func_176223_P());
                    }
                    if (raining) {
                        if (world.func_175708_f(pos, true)) {
                            world.func_175656_a(pos, NibiruBlocks.INFECTED_SNOW_LAYER.func_176223_P());
                        }
                        if (world.func_180494_b(pos1).func_76738_d()) {
                            world.func_180495_p(pos1).func_177230_c().func_176224_k(world, pos1);
                        }
                    }
                }
                if (!(biome instanceof BiomeInfectedDesert) && !(biome instanceof BiomeGreenVein) || world.field_73012_v.nextInt(250000) != 0) continue;
                world.func_72838_d((Entity)bolt);
            }
        }
    }

    private BlockPos adjustPosToNearbyEntity(World world, BlockPos pos) {
        BlockPos blockpos = world.func_175725_q(pos);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos, new BlockPos(blockpos.func_177958_n(), world.func_72800_K(), blockpos.func_177952_p()));
        List list = world.func_175647_a(EntityLivingBase.class, axisalignedbb, living -> living != null && living.func_70089_S() && world.func_175678_i(living.func_180425_c()));
        if (!list.isEmpty()) {
            return ((EntityLivingBase)list.get(world.field_73012_v.nextInt(list.size()))).func_180425_c();
        }
        if (blockpos.func_177956_o() == -1) {
            blockpos = blockpos.func_177981_b(2);
        }
        return blockpos;
    }

    private boolean canBeamStrike(World world, BlockPos strikePosition) {
        if (!world.func_175678_i(strikePosition)) {
            return false;
        }
        if (world.func_175725_q(strikePosition).func_177956_o() > strikePosition.func_177956_o()) {
            return false;
        }
        return this.getSunBrightness(world) < 0.25f;
    }

    private float getSunBrightness(World world) {
        float partialTicks = 1.0f;
        float angle = world.func_72826_c(partialTicks);
        float celestialAngle = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        celestialAngle = MathHelper.func_76131_a((float)celestialAngle, (float)0.0f, (float)1.0f);
        celestialAngle = 1.0f - celestialAngle;
        celestialAngle = (float)((double)celestialAngle * (1.0 - (double)(world.func_72867_j(partialTicks) * 5.0f) / 16.0));
        celestialAngle = (float)((double)celestialAngle * (1.0 - (double)(world.func_72819_i(partialTicks) * 5.0f) / 16.0));
        return celestialAngle * 0.8f + 0.2f;
    }
}

