/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core;

import java.io.File;
import java.util.Arrays;
import micdoodle8.mods.galacticraft.api.world.BiomeGenBaseGC;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.event.ClientEventHandler;
import stevekung.mods.moreplanets.core.event.EntityEventHandler;
import stevekung.mods.moreplanets.core.event.GeneralEventHandler;
import stevekung.mods.moreplanets.core.event.MissingMappingHandler;
import stevekung.mods.moreplanets.core.event.WorldTickEventHandler;
import stevekung.mods.moreplanets.core.handler.GuiHandlerMP;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPDimensions;
import stevekung.mods.moreplanets.init.MPEntities;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPOreDictionary;
import stevekung.mods.moreplanets.init.MPOthers;
import stevekung.mods.moreplanets.init.MPPlanets;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.init.MPSchematics;
import stevekung.mods.moreplanets.init.MPTileEntities;
import stevekung.mods.moreplanets.items.capsule.ItemCapsule;
import stevekung.mods.moreplanets.network.PacketSimpleMP;
import stevekung.mods.moreplanets.proxy.ServerProxyMP;
import stevekung.mods.moreplanets.recipe.CraftingManagerMP;
import stevekung.mods.moreplanets.util.CompatibilityManagerMP;
import stevekung.mods.moreplanets.util.CreativeTabsMP;
import stevekung.mods.moreplanets.util.MPLog;
import stevekung.mods.moreplanets.util.SmeltWithDataFunction;
import stevekung.mods.moreplanets.util.VersionChecker;
import stevekung.mods.moreplanets.util.helper.CommonRegisterHelper;

@Mod(modid="moreplanets", name="More Planets", version="2.0.21", dependencies="required-after:galacticraftcore@[4.0.2.224,); required-after:galacticraftplanets@[4.0.2.224,); required-after:micdoodlecore; after:forge@[14.23.5.2838,);", guiFactory="stevekung.mods.moreplanets.core.config.ConfigGuiFactoryMP", certificateFingerprint="b3468b224a74e296555ad7efeb35f482e6f445de", acceptedMinecraftVersions="[1.12.2]")
public class MorePlanetsCore {
    public static final String NAME = "More Planets";
    public static final String MOD_ID = "moreplanets";
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 0;
    public static final int BUILD_VERSION = 21;
    public static final String VERSION = "2.0.21";
    public static final String GUI_FACTORY = "stevekung.mods.moreplanets.core.config.ConfigGuiFactoryMP";
    public static final String CLIENT_CLASS = "stevekung.mods.moreplanets.proxy.ClientProxyMP";
    public static final String SERVER_CLASS = "stevekung.mods.moreplanets.proxy.ServerProxyMP";
    public static final String FORGE_VERSION = "after:forge@[14.23.5.2838,);";
    public static final String DEPENDENCIES = "required-after:galacticraftcore@[4.0.2.224,); required-after:galacticraftplanets@[4.0.2.224,); required-after:micdoodlecore; after:forge@[14.23.5.2838,);";
    public static final String MC_VERSION = String.valueOf(FMLInjectionData.data()[4]);
    public static final String CERTIFICATE = "b3468b224a74e296555ad7efeb35f482e6f445de";
    private static boolean DEOBFUSCATED;
    @SidedProxy(clientSide="stevekung.mods.moreplanets.proxy.ClientProxyMP", serverSide="stevekung.mods.moreplanets.proxy.ServerProxyMP")
    public static ServerProxyMP PROXY;
    @Mod.Instance(value="moreplanets")
    public static MorePlanetsCore INSTANCE;
    public static boolean[] STATUS_CHECK;
    public static CreativeTabsMP BLOCK_TAB;
    public static CreativeTabsMP ITEM_TAB;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CompatibilityManagerMP.init();
        ConfigManagerMP.init(new File(event.getModConfigurationDirectory(), "MorePlanets.cfg"));
        MorePlanetsCore.initModInfo(event.getModMetadata());
        BLOCK_TAB = new CreativeTabsMP("MorePlanetsBlocks");
        ITEM_TAB = new CreativeTabsMP("MorePlanetsItems");
        MPBlocks.init();
        MPItems.init();
        MPEntities.init();
        MPPlanets.init();
        MPPotions.init();
        MPBiomes.init();
        MPOthers.init();
        MPPlanets.register();
        PROXY.registerPreRendering();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MPTileEntities.init();
        MPOreDictionary.init();
        GalacticraftCore.packetPipeline.addDiscriminator(ConfigManagerMP.idNetworkHandler, PacketSimpleMP.class);
        BLOCK_TAB.setDisplayItemStack(new ItemStack(MPBlocks.ROCKET_CRUSHER));
        ITEM_TAB.setDisplayItemStack(new ItemStack(MPItems.SPACE_WARPER_CORE));
        PROXY.registerInitRendering();
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SmeltWithDataFunction.Serializer());
        for (BiomeGenBaseGC biome : MPBiomes.biomeList) {
            biome.registerTypes((Biome)biome);
        }
        if (CommonRegisterHelper.isClient()) {
            CommonRegisterHelper.postRegisteredSortBlock();
            CommonRegisterHelper.postRegisteredSortItem();
            CommonRegisterHelper.registerForgeEvent(new ClientEventHandler());
        }
        CommonRegisterHelper.registerForgeEvent(new EntityEventHandler());
        CommonRegisterHelper.registerForgeEvent(new GeneralEventHandler());
        CommonRegisterHelper.registerForgeEvent(new WorldTickEventHandler());
        CommonRegisterHelper.registerForgeEvent(new MissingMappingHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        VersionChecker.startCheck();
        PROXY.registerPostRendering();
        CommonRegisterHelper.registerGUIHandler(this, new GuiHandlerMP());
        CraftingManagerMP.init();
        MPSchematics.init();
        MPDimensions.init();
        ItemCapsule.init = true;
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        WorldTickEventHandler.startedDimensionData = null;
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (!MorePlanetsCore.isObfuscatedEnvironment()) {
            throw new RuntimeException("Invalid fingerprint detected! This version will NOT be supported by the author!");
        }
        MPLog.info("Development environment detected! Ignore certificate check.");
    }

    public static boolean isObfuscatedEnvironment() {
        return DEOBFUSCATED;
    }

    private static void initModInfo(ModMetadata info) {
        info.autogenerated = false;
        info.modId = MOD_ID;
        info.name = NAME;
        info.version = VERSION;
        info.description = "An add-on exploration with custom planets for Galacticraft!";
        info.url = "https://minecraft.curseforge.com/projects/galacticraft-add-on-more-planets";
        info.credits = "All credits to Galacticraft Sources/API and some people who helped.";
        info.authorList = Arrays.asList("SteveKunG");
    }

    static {
        STATUS_CHECK = new boolean[]{false, false, false};
        FluidRegistry.enableUniversalBucket();
        try {
            DEOBFUSCATED = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

