/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.tileentity.TileEntityRocketCrusher;
import stevekung.mods.moreplanets.util.ItemDescription;
import stevekung.mods.moreplanets.util.blocks.BlockTileMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockDescription;
import stevekung.mods.moreplanets.util.blocks.ISingleBlockRender;
import stevekung.mods.moreplanets.util.helper.ItemDescriptionHelper;

public class BlockRocketCrusher
extends BlockTileMP
implements IBlockDescription,
ISingleBlockRender {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockRocketCrusher(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRocketCrusher) {
            TileEntityRocketCrusher tileEntity = (TileEntityRocketCrusher)tile;
            ItemStack itemStack = new ItemStack(AsteroidsItems.basicItem, 1, 0);
            if (tileEntity.processTicks > 20) {
                for (int i = 0; i < 2; ++i) {
                    world.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)pos.func_177958_n() + (double)rand.nextFloat(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + (double)rand.nextFloat(), 0.1 * ((double)rand.nextFloat() - 0.5), 0.2, ((double)rand.nextFloat() - 0.5) * 0.1, new int[]{Item.func_150891_b((Item)itemStack.func_77973_b()), itemStack.func_77960_j()});
                }
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        world.func_180501_a(pos, this.func_176203_a((this.func_176201_c(state) & 0xC) + change), 3);
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("EnergyStored") && world.func_175625_s(pos) instanceof TileEntityRocketCrusher) {
            TileEntityRocketCrusher electric = (TileEntityRocketCrusher)world.func_175625_s(pos);
            electric.storage.setEnergyStored(itemStack.func_77978_p().func_74760_g("EnergyStored"));
        }
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        TileBaseUniversalElectrical.onUseWrenchBlock((IBlockState)state, (World)world, (BlockPos)pos, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)FACING)));
        return true;
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)MorePlanetsCore.INSTANCE, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityRocketCrusher();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }

    @Override
    public ItemDescription getDescription() {
        return (itemStack, list) -> list.addAll(ItemDescriptionHelper.getDescription(this.func_149739_a() + ".description"));
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE_BLOCK;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        if (tile instanceof TileEntityRocketCrusher) {
            TileEntityRocketCrusher electric = (TileEntityRocketCrusher)tile;
            ItemStack itemStack = new ItemStack((Block)this);
            if (electric.getEnergyStoredGC() > 0.0f) {
                itemStack.func_77982_d(new NBTTagCompound());
                itemStack.func_77978_p().func_74776_a("EnergyStored", electric.getEnergyStoredGC());
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
        }
    }

    @Override
    public String getName() {
        return "rocket_crusher";
    }
}

